/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.fuels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import reborncore.api.praescriptum.fuels.FuelHandler;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.common.util.ItemUtils;

public class Fuel {
    private FuelHandler handler;
    private List<InputIngredient<?>> inputIngredients = new ArrayList();
    private double energyOutput = 0.0;
    private NBTTagCompound metadata;

    public Fuel(FuelHandler handler) {
        this.handler = handler;
    }

    public Fuel addSources(Collection<InputIngredient<?>> inputs) {
        this.inputIngredients.addAll(inputs);
        return this;
    }

    public Fuel addItemSource(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            throw new IllegalArgumentException("Source cannot be empty");
        }
        this.inputIngredients.add(ItemStackInputIngredient.of(itemStack));
        return this;
    }

    public Fuel addItemSource(String oreDict) {
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict));
        return this;
    }

    public Fuel addItemSource(String oreDict, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Source cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount));
        return this;
    }

    public Fuel addItemSource(String oreDict, int amount, Integer meta) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Source cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount, meta));
        return this;
    }

    public Fuel addFluidSource(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            throw new IllegalArgumentException("Source cannot be empty");
        }
        this.inputIngredients.add(FluidStackInputIngredient.of(fluidStack));
        return this;
    }

    public Fuel addFluidSource(Fluid fluid) {
        return this.addFluidSource(fluid, 1);
    }

    public Fuel addFluidSource(Fluid fluid, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Source cannot be empty");
        }
        this.inputIngredients.add(FluidStackInputIngredient.of(new FluidStack(fluid, amount)));
        return this;
    }

    public Fuel withEnergyOutput(double energyOutput) {
        if (energyOutput < 0.0) {
            throw new IllegalArgumentException("Energy output cannot be less than 0.0D");
        }
        this.energyOutput = energyOutput;
        return this;
    }

    public Fuel withEnergyPerTick(double energyPerTick) {
        if (energyPerTick < 0.0) {
            throw new IllegalArgumentException("Energy per tick cannot be less than 0.0D");
        }
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74780_a("energyPerTick", energyPerTick);
        return this;
    }

    public Fuel withMetadata(NBTTagCompound metadata) {
        this.metadata = metadata;
        return this;
    }

    public Fuel withMetadata(String key, int value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74768_a(key, value);
        return this;
    }

    public Fuel withMetadata(String key, short value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74777_a(key, value);
        return this;
    }

    public Fuel withMetadata(String key, byte value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74774_a(key, value);
        return this;
    }

    public Fuel withMetadata(String key, float value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74776_a(key, value);
        return this;
    }

    public Fuel withMetadata(String key, double value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74780_a(key, value);
        return this;
    }

    public Fuel withMetadata(String key, boolean value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74757_a(key, value);
        return this;
    }

    public void register() {
        this.register(false);
    }

    public void register(boolean replace) {
        boolean success = this.handler.addFuel(this, replace);
        if (!success) {
            this.handler.logger.warn("Registration failed for input " + this);
        }
    }

    public List<InputIngredient<?>> getInputIngredients() {
        return this.inputIngredients;
    }

    public double getEnergyOutput() {
        return this.energyOutput;
    }

    public double getEnergyPerTick() {
        if (this.metadata == null) {
            return 0.0;
        }
        return this.metadata.func_74764_b("energyPerTick") ? this.metadata.func_74769_h("energyPerTick") : 0.0;
    }

    public NBTTagCompound getMetadata() {
        return this.metadata;
    }

    public static Fuel readFromNBT(FuelHandler fuelHandler, NBTTagCompound tag) {
        Fuel ret = fuelHandler.addFuel();
        NBTTagList inputIngredients = tag.func_150295_c("inputIngredients", 10);
        block5: for (int index = 0; index < inputIngredients.func_74745_c(); ++index) {
            NBTTagCompound inputIngredient = inputIngredients.func_150305_b(index);
            byte type = inputIngredient.func_74771_c("type");
            switch (type) {
                case 0: {
                    ItemStack itemStack = new ItemStack(inputIngredient);
                    inputIngredient.func_74767_n("consumable");
                    ret.addItemSource(itemStack);
                    continue block5;
                }
                case 1: {
                    String oreDictionaryEntry = inputIngredient.func_74779_i("oreDictionaryEntry");
                    int amount = inputIngredient.func_74762_e("amount");
                    int meta = inputIngredient.func_74762_e("meta");
                    inputIngredient.func_74767_n("consumable");
                    ret.addItemSource(oreDictionaryEntry, amount);
                    continue block5;
                }
                case 2: {
                    FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputIngredient);
                    inputIngredient.func_74767_n("consumable");
                    ret.addFluidSource(Objects.requireNonNull(fluidStack));
                }
            }
        }
        ret.withEnergyOutput(tag.func_74769_h("energyOutput"));
        if (tag.func_74764_b("metadata")) {
            ret.withMetadata(tag.func_74775_l("metadata"));
        }
        return ret;
    }

    public static NBTTagCompound writeToNBT(Fuel fuel) {
        NBTTagCompound ret = new NBTTagCompound();
        NBTTagList inputIngredients = new NBTTagList();
        for (InputIngredient<?> inputIngredient : fuel.inputIngredients) {
            NBTTagCompound temp;
            if (inputIngredient instanceof ItemStackInputIngredient) {
                temp = new NBTTagCompound();
                temp.func_74774_a("type", (byte)0);
                ((ItemStack)((ItemStackInputIngredient)inputIngredient).ingredient).func_77955_b(temp);
                temp.func_74757_a("consumable", inputIngredient.consumable);
                inputIngredients.func_74742_a((NBTBase)temp);
                continue;
            }
            if (inputIngredient instanceof OreDictionaryInputIngredient) {
                temp = new NBTTagCompound();
                temp.func_74774_a("type", (byte)1);
                temp.func_74778_a("oreDictionaryEntry", (String)((OreDictionaryInputIngredient)inputIngredient).ingredient);
                temp.func_74768_a("amount", ((OreDictionaryInputIngredient)inputIngredient).amount);
                temp.func_74768_a("meta", ((OreDictionaryInputIngredient)inputIngredient).meta.intValue());
                temp.func_74757_a("consumable", inputIngredient.consumable);
                inputIngredients.func_74742_a((NBTBase)temp);
                continue;
            }
            if (!(inputIngredient instanceof FluidStackInputIngredient)) continue;
            temp = new NBTTagCompound();
            temp.func_74774_a("type", (byte)2);
            ((FluidStack)((FluidStackInputIngredient)inputIngredient).ingredient).writeToNBT(temp);
            temp.func_74757_a("consumable", inputIngredient.consumable);
            inputIngredients.func_74742_a((NBTBase)temp);
        }
        ret.func_74782_a("inputIngredients", (NBTBase)inputIngredients);
        ret.func_74780_a("energyOutput", fuel.energyOutput);
        if (fuel.metadata.func_82582_d()) {
            ret.func_74782_a("metadata", (NBTBase)fuel.metadata);
        }
        return ret;
    }
}

