/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.data;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.helper.ItemStackHelper;
import de.eydamos.backpack.misc.Constants;
import de.eydamos.backpack.util.GeneralUtil;
import de.eydamos.backpack.util.NBTUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class PlayerSave
extends WorldSavedData
implements IInventory {
    private EntityPlayer player;
    private ItemStack[] inventory;

    public PlayerSave() {
        super(Constants.PLAYERS_PATH + "DUMMY");
    }

    public PlayerSave(String name) {
        super(name);
    }

    @ParametersAreNonnullByDefault
    public void func_76184_a(NBTTagCompound nbt) {
        this.inventory = ItemStackHelper.createInventory(1);
        if (NBTUtil.hasTag(nbt, "backpack")) {
            NBTTagCompound backpack = NBTUtil.getCompoundTag(nbt, "backpack");
            this.inventory[0] = new ItemStack(backpack);
        }
    }

    @ParametersAreNonnullByDefault
    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        if (this.inventory != null && !this.inventory[0].func_190926_b()) {
            NBTTagCompound backpack = new NBTTagCompound();
            this.inventory[0].func_77955_b(backpack);
            NBTUtil.setCompoundTag(nbt, "backpack", backpack);
        }
        return nbt;
    }

    private void initialize(EntityPlayer player) {
        this.player = player;
        if (this.inventory == null) {
            this.inventory = ItemStackHelper.createInventory(1);
        }
    }

    public ItemStack getBackpack() {
        if (this.inventory != null) {
            return this.inventory[0];
        }
        return ItemStack.field_190927_a;
    }

    public static PlayerSave loadPlayer(World world, EntityPlayer player) {
        String UUID2 = GeneralUtil.getPlayerUUID(player);
        MapStorage storage = world.func_175693_T();
        PlayerSave instance = (PlayerSave)storage.func_75742_a(PlayerSave.class, Constants.PLAYERS_PATH + UUID2);
        if (instance == null) {
            instance = new PlayerSave(Constants.PLAYERS_PATH + UUID2);
            storage.func_75745_a(Constants.PLAYERS_PATH + UUID2, (WorldSavedData)instance);
        }
        instance.initialize(player);
        return instance;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (this.inventory != null && index >= 0 && index < this.inventory.length) {
            return this.inventory[index];
        }
        return ItemStack.field_190927_a;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemstack = this.func_70301_a(index);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_190916_E() <= amount) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                itemstack = itemstack.func_77979_a(amount);
                if (this.func_70301_a(index).func_190916_E() == 0) {
                    this.func_70299_a(index, ItemStack.field_190927_a);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return itemstack;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (!this.func_70301_a(index).func_190926_b()) {
            itemstack = this.func_70301_a(index);
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
        return itemstack;
    }

    @ParametersAreNonnullByDefault
    public void func_70299_a(int index, ItemStack newContent) {
        if (this.inventory != null && index >= 0 && index < this.inventory.length) {
            this.inventory[index] = newContent;
            if (!newContent.func_190926_b() && newContent.func_190916_E() > this.func_70297_j_()) {
                newContent.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
            if (index == 0 && GeneralUtil.isServerSide(this.player.field_70170_p)) {
                Backpack.packetHandler.propagateCarriedBackpack(this.player);
            }
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    @ParametersAreNonnullByDefault
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void func_174889_b(EntityPlayer player) {
    }

    @ParametersAreNonnullByDefault
    public void func_174886_c(EntityPlayer player) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.length; ++i) {
                this.inventory[i] = ItemStack.field_190927_a;
            }
        }
    }

    @MethodsReturnNonnullByDefault
    public String func_70005_c_() {
        return "text.backpack.gui.title.special_slots";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @MethodsReturnNonnullByDefault
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_70296_d() {
        super.func_76185_a();
    }
}

