/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.IPowerGenerator;
import erogenousbeef.bigreactors.common.multiblock.IPowerProvider;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.tileentity.PowerTapHandler;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
class PowerTapHandlerTesla
extends PowerTapHandler
implements ITeslaHolder,
ITeslaProducer {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> CAPABILITY_TESLA_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> CAPABILITY_TESLA_PRODUCER = null;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> CAPABILITY_TESLA_HOLDER = null;
    private ITeslaConsumer _consumer = null;

    public PowerTapHandlerTesla(RectangularMultiblockTileEntityBase part) {
        super(part);
    }

    @Override
    public boolean isProviderConnected() {
        return null != this._consumer;
    }

    @Override
    public long onProvidePower(long units) {
        if (null == this._consumer) {
            return units;
        }
        long energyAccepted = this._consumer.givePower(units, false);
        return units - energyAccepted;
    }

    @Override
    public void checkForConnections(IBlockAccess world, BlockPos position) {
        boolean wasConnected = this._consumer != null;
        EnumFacing approachDirection = this._part.getOutwardFacing();
        if (null == approachDirection) {
            wasConnected = false;
            this._consumer = null;
        } else {
            this._consumer = null;
            BlockPos targetPosition = position.func_177972_a(approachDirection);
            TileEntity te = world.func_175625_s(targetPosition);
            if (null != te && !(te instanceof IPowerProvider) && null != CAPABILITY_TESLA_CONSUMER && te.hasCapability(CAPABILITY_TESLA_CONSUMER, approachDirection)) {
                this._consumer = (ITeslaConsumer)te.getCapability(CAPABILITY_TESLA_CONSUMER, approachDirection.func_176734_d());
            }
        }
        boolean isConnected = this._consumer != null;
        World partWorld = this._part.func_145831_w();
        if (wasConnected != isConnected && WorldHelper.calledByLogicalClient((World)partWorld)) {
            WorldHelper.notifyBlockUpdate((World)partWorld, (BlockPos)this._part.getWorldPosition(), null, null);
        }
    }

    public long getStoredPower() {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0L : Math.min(generator.getEnergyStored(), PowerSystem.Tesla.maxCapacity);
    }

    public long getCapacity() {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0L : Math.min(generator.getEnergyCapacity(), PowerSystem.Tesla.maxCapacity);
    }

    public long takePower(long power, boolean simulated) {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0L : generator.extractEnergy(Math.min(power, PowerSystem.Tesla.maxCapacity), simulated);
    }
}

