/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TransferItemsRequestMessage
extends AbstractMessage<TransferItemsRequestMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private ItemStack itemStack;
    private int quantity;
    private boolean attemptResolve;
    private int dimension;

    public TransferItemsRequestMessage() {
    }

    public TransferItemsRequestMessage(@NotNull AbstractBuildingView building, ItemStack itemStack, int quantity, boolean attemptResolve) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.itemStack = itemStack;
        this.quantity = quantity;
        this.attemptResolve = attemptResolve;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.quantity = buf.readInt();
        this.attemptResolve = buf.readBoolean();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.attemptResolve);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(TransferItemsRequestMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null) {
            Log.getLogger().warn("TransferItemsRequestMessage colony is null");
            return;
        }
        IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (building == null) {
            Log.getLogger().warn("TransferItemsRequestMessage building is null");
            return;
        }
        if (message.quantity <= 0) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        Item item = message.itemStack.func_77973_b();
        int amountToTake = isCreative ? message.quantity : Math.min(message.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, message.itemStack, true, true)));
        ItemStack itemStackToTake = new ItemStack(item, amountToTake, message.itemStack.func_77952_i());
        itemStackToTake.func_77982_d(message.itemStack.func_77978_p());
        ItemStack remainingItemStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)building.getTileEntity(), itemStackToTake);
        if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue() || ItemStackUtils.getSize(remainingItemStack) != ItemStackUtils.getSize(itemStackToTake)) {
            building.getTileEntity().func_70296_d();
        }
        if (!isCreative) {
            ItemStack itemsTaken;
            for (int amountToRemoveFromPlayer = amountToTake - ItemStackUtils.getSize(remainingItemStack); amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, message.itemStack, true, true));
                itemsTaken = player.field_71071_by.func_70298_a(slot, amountToRemoveFromPlayer);
            }
        }
        if (this.attemptResolve) {
            building.overruleNextOpenRequestWithStack(this.itemStack);
        }
    }
}

