/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class LumberjackRestrictionToggleMessage
extends AbstractMessage<LumberjackRestrictionToggleMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean shouldRestrict;
    private int dimension;

    public LumberjackRestrictionToggleMessage() {
    }

    public LumberjackRestrictionToggleMessage(BuildingLumberjack.View building, boolean shouldRestrict) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.shouldRestrict = shouldRestrict;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.shouldRestrict = buf.readBoolean();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.shouldRestrict);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(LumberjackRestrictionToggleMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingWorker building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingWorker.class);
            if (building instanceof BuildingLumberjack) {
                ((BuildingLumberjack)building).setShouldRestrict(message.shouldRestrict);
            }
        }
    }
}

