/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.entity.mobs.EntityMercenary;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HireMercenaryMessage
extends AbstractMessage<HireMercenaryMessage, IMessage> {
    private int colonyID = 0;
    private int dimension = 0;

    public HireMercenaryMessage() {
    }

    public HireMercenaryMessage(IColonyView colony) {
        this.colonyID = colony.getID();
        this.dimension = colony.getDimension();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyID = byteBuf.readInt();
        this.dimension = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyID);
        byteBuf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(HireMercenaryMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyID, message.dimension);
        if (colony != null) {
            EntityMercenary.spawnMercenariesInColony(colony);
            colony.getWorld().func_184134_a((double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), SoundEvents.field_193784_dd, null, 1.0f, 1.0f, true);
        }
    }
}

