/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EnchanterQtySetMessage
extends AbstractMessage<EnchanterQtySetMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int dimension;
    private int qty;

    public EnchanterQtySetMessage() {
    }

    public EnchanterQtySetMessage(@NotNull BuildingEnchanter.View building, int qty) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.qty = qty;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
        this.qty = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
        buf.writeInt(this.qty);
    }

    @Override
    public void messageOnServerThread(EnchanterQtySetMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingEnchanter building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingEnchanter.class);
            if (building != null) {
                building.setDailyDrainage(message.qty);
            }
        }
    }
}

