/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractMessage<BuildRequestMessage, IMessage> {
    public static final int BUILD = 0;
    public static final int REPAIR = 1;
    private BlockPos buildingId;
    private int colonyId;
    private int mode;
    private int dimension;
    private BlockPos builder;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(@NotNull IBuildingView building, int mode, BlockPos builder) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mode = mode;
        this.dimension = building.getColony().getDimension();
        this.builder = builder;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.mode = buf.readInt();
        this.dimension = buf.readInt();
        this.builder = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mode);
        buf.writeInt(this.dimension);
        BlockPosUtil.writeToByteBuf(buf, this.builder);
    }

    @Override
    public void messageOnServerThread(BuildRequestMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null) {
            return;
        }
        IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (building == null) {
            return;
        }
        if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        if (building.hasWorkOrder()) {
            building.removeWorkOrder();
        } else {
            switch (message.mode) {
                case 0: {
                    building.requestUpgrade((EntityPlayer)player, message.builder);
                    break;
                }
                case 1: {
                    building.requestRepair(message.builder);
                    break;
                }
            }
        }
    }
}

