/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;

public class CitizenExperienceHandler
implements ICitizenExperienceHandler {
    private final EntityCitizen citizen;
    private double skillModifier = 0.0;
    private int level;

    public CitizenExperienceHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void updateLevel() {
        this.level = this.citizen.getCitizenData() == null ? 0 : this.citizen.getCitizenData().getLevel();
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_LEVEL, (Object)this.level);
        if (this.citizen.getCitizenData().getJob() != null) {
            this.citizen.getCitizenData().getJob().onLevelUp(this.level);
        }
    }

    @Override
    public void setSkillModifier(int modifier) {
        this.skillModifier = modifier;
    }

    @Override
    public void addExperience(double xp) {
        double citizenHutMaxLevel;
        IBuilding home = this.citizen.getCitizenColonyHandler().getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        double d = citizenHutMaxLevel = home == null ? 1.0 : (double)home.getMaxBuildingLevel();
        if (this.citizen.getCitizenData() != null) {
            this.addExperienceToCitizenData(xp, citizenHutLevel, citizenHutMaxLevel);
        }
    }

    private void addExperienceToCitizenData(double xp, double citizenHutLevel, double citizenHutMaxLevel) {
        double maxValue;
        double saturation;
        if (citizenHutLevel < citizenHutMaxLevel && Math.pow(2.0, citizenHutLevel + 1.0) <= (double)this.citizen.getCitizenData().getLevel() || this.citizen.getCitizenData().getLevel() >= 99) {
            return;
        }
        double localXp = xp * this.skillModifier / 100.0;
        double workBuildingLevel = this.citizen.getCitizenColonyHandler().getWorkBuilding() == null ? 0.0 : (double)this.citizen.getCitizenColonyHandler().getWorkBuilding().getBuildingLevel();
        double bonusXp = workBuildingLevel * (1.0 + citizenHutLevel) / Math.log((double)this.citizen.getCitizenData().getLevel() + 2.0) / 2.0;
        XpBasedOnSaturationCalculator xpBasedOnSaturationCalculator = new XpBasedOnSaturationCalculator(localXp *= bonusXp, saturation = this.citizen.getCitizenData().getSaturation()).invoke();
        if (xpBasedOnSaturationCalculator.is()) {
            return;
        }
        localXp = xpBasedOnSaturationCalculator.getLocalXp();
        if (localXp > (maxValue = 2.147483647E9 - this.citizen.getCitizenData().getExperience())) {
            localXp = maxValue;
        }
        localXp = this.applyMending(localXp);
        this.citizen.getCitizenData().addExperience(localXp);
        while (ExperienceUtils.getXPNeededForNextLevel(this.citizen.getCitizenData().getLevel()) < this.citizen.getCitizenData().getExperience()) {
            this.citizen.getCitizenData().levelUp();
        }
        this.updateLevel();
        this.citizen.markDirty();
    }

    private double applyMending(double xp) {
        double localXp = xp;
        ItemStack tool = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)this.citizen);
        if (!ItemStackUtils.isEmpty(tool).booleanValue() && tool.func_77951_h()) {
            double dmgHealed = Math.min(localXp / 2.0, (double)tool.func_77952_i());
            localXp -= dmgHealed * 2.0;
            tool.func_77964_b(tool.func_77952_i() - (int)Math.ceil(dmgHealed));
        }
        return localXp;
    }

    @Override
    public void dropExperience() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K && this.citizen.getRecentlyHit() > 0 && this.citizen.checkCanDropLoot() && CompatibilityUtils.getWorldFromCitizen(this.citizen).func_82736_K().func_82766_b("doMobLoot")) {
            int j;
            for (int experience = (int)this.citizen.getCitizenData().getExperience(); experience > 0; experience -= j) {
                j = EntityXPOrb.func_70527_a((int)experience);
                CompatibilityUtils.getWorldFromCitizen(this.citizen).func_72838_d((Entity)new EntityXPOrb(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v, j));
            }
        }
        int i = 0;
        while ((double)i < 20.0) {
            double d2 = this.citizen.getRandom().nextGaussian() * 0.02;
            double d0 = this.citizen.getRandom().nextGaussian() * 0.02;
            double d1 = this.citizen.getRandom().nextGaussian() * 0.02;
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.citizen.field_70165_t + this.citizen.getRandom().nextDouble() * (double)this.citizen.field_70130_N * 2.0 - (double)this.citizen.field_70130_N, this.citizen.field_70163_u + this.citizen.getRandom().nextDouble() * (double)this.citizen.field_70131_O, this.citizen.field_70161_v + this.citizen.getRandom().nextDouble() * (double)this.citizen.field_70130_N * 2.0 - (double)this.citizen.field_70130_N, d2, d0, d1, new int[0]);
            ++i;
        }
    }

    @Override
    public void gatherXp() {
        for (EntityXPOrb orb : this.getXPOrbsOnGrid()) {
            this.addExperience((double)orb.func_70526_d() / 2.0);
            orb.func_70106_y();
        }
    }

    private List<EntityXPOrb> getXPOrbsOnGrid() {
        AxisAlignedBB bb = new AxisAlignedBB(this.citizen.field_70165_t - 2.0, this.citizen.field_70163_u - 2.0, this.citizen.field_70161_v - 2.0, this.citizen.field_70165_t + 2.0, this.citizen.field_70163_u + 2.0, this.citizen.field_70161_v + 2.0);
        return CompatibilityUtils.getWorldFromCitizen(this.citizen).func_72872_a(EntityXPOrb.class, bb);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    private class XpBasedOnSaturationCalculator {
        private final double saturation;
        private boolean myResult;
        private double localXp;

        public XpBasedOnSaturationCalculator(double localXp, double saturation) {
            this.localXp = localXp;
            this.saturation = saturation;
        }

        boolean is() {
            return this.myResult;
        }

        public double getLocalXp() {
            return this.localXp;
        }

        public XpBasedOnSaturationCalculator invoke() {
            if (this.saturation < 5.0) {
                if (this.saturation <= 0.0) {
                    this.myResult = true;
                    return this;
                }
                this.localXp = this.saturation < 3.0 ? (this.localXp -= this.localXp * 0.05 * this.saturation) : (this.localXp -= this.localXp * 0.01 * this.saturation);
            } else if (this.saturation > 5.0) {
                this.localXp = this.saturation > 7.0 ? (this.localXp += this.localXp * 0.05 * this.saturation) : (this.localXp += this.localXp * 0.01 * this.saturation);
            }
            this.myResult = false;
            return this;
        }
    }
}

