/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.util.AdvancementUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.ItemParticleEffectMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityAIEatTask
extends EntityAIBase {
    private static final int MINUTES_BETWEEN_FOOD_CHECKS = 2;
    private static final int MINUTES_WAITING_TIME = 2;
    private static final int MIN_DISTANCE_TO_RESTAURANT = 5;
    private static final int PLACE_TO_EAT_DISTANCE = 5;
    private static final int REQUIRED_TIME_TO_EAT = 5;
    private final EntityCitizen citizen;
    private EatingState currentState = EatingState.IDLE;
    private int waitingTicks = 0;
    private int foodSlot = -1;
    private BlockPos placeToPath;
    private int delayTicks = 0;

    public EntityAIEatTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        if (this.currentState != EatingState.IDLE) {
            return true;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null || this.citizen.getCitizenData().getSaturation() >= 7.0 || !this.citizen.isOkayToEat() && this.citizen.getCitizenData().getSaturation() > 0.0) {
            return false;
        }
        if (citizenData.getSaturation() <= 5.0) {
            ++this.waitingTicks;
            return this.waitingTicks >= 2400 && citizenData.getSaturation() < 3.0 || citizenData.getJob() == null || citizenData.getSaturation() == 0.0;
        }
        return citizenData.getSaturation() <= 7.0 && this.checkForFood(citizenData) == EatingState.EAT && this.citizen.isOkayToEat();
    }

    public void func_75246_d() {
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null) {
            return;
        }
        if (++this.delayTicks % 20 != 0) {
            return;
        }
        this.delayTicks = 0;
        switch (this.currentState) {
            case CHECK_FOR_FOOD: {
                this.currentState = this.checkForFood(citizenData);
                return;
            }
            case GO_TO_HUT: {
                this.currentState = this.goToHut(citizenData);
                return;
            }
            case SEARCH_RESTAURANT: {
                this.currentState = this.searchRestaurant(citizenData);
                return;
            }
            case GO_TO_RESTAURANT: {
                this.currentState = this.goToRestaurant();
                return;
            }
            case WAIT_FOR_FOOD: {
                this.currentState = this.waitForFood(citizenData);
                return;
            }
            case FIND_PLACE_TO_EAT: {
                this.currentState = this.findPlaceToEat();
                return;
            }
            case GET_FOOD_YOURSELF: {
                this.currentState = this.getFoodYourself();
                return;
            }
            case EAT: {
                this.currentState = this.eat(citizenData);
                return;
            }
        }
        this.reset();
    }

    private EatingState eat(ICitizenData citizenData) {
        if (this.foodSlot == -1) {
            return EatingState.CHECK_FOR_FOOD;
        }
        ItemStack stack = citizenData.getInventory().func_70301_a(this.foodSlot);
        if (!ItemStackUtils.CAN_EAT.test(stack)) {
            return EatingState.CHECK_FOR_FOOD;
        }
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, stack);
        this.citizen.func_184609_a(EnumHand.MAIN_HAND);
        this.citizen.func_184185_a(SoundEvents.field_187537_bA, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.getRandom()));
        MineColonies.getNetwork().sendToAllTracking((IMessage)new ItemParticleEffectMessage(this.citizen.func_184614_ca(), this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v, this.citizen.field_70125_A, this.citizen.field_70177_z, this.citizen.func_70047_e()), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 5) {
            return EatingState.EAT;
        }
        ItemFood itemFood = (ItemFood)stack.func_77973_b();
        citizenData.increaseSaturation((double)itemFood.func_150905_g(stack) / 2.0);
        citizenData.getInventory().func_70298_a(this.foodSlot, 1);
        IColony citizenColony = this.citizen.getCitizenColonyHandler().getColony();
        if (citizenColony != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(citizenColony, playerMP -> AdvancementTriggers.CITIZEN_EAT_FOOD.trigger((EntityPlayerMP)playerMP, new ItemStack((Item)itemFood)));
        }
        citizenData.markDirty();
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        if (citizenData.getSaturation() < 10.0 && !stack.func_190926_b()) {
            this.waitingTicks = 0;
            return EatingState.EAT;
        }
        return EatingState.IDLE;
    }

    private EatingState getFoodYourself() {
        if (this.placeToPath == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return EatingState.IDLE;
        }
        BlockPos restaurant = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (restaurant == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        IBuilding cookBuilding = colony.getBuildingManager().getBuilding(restaurant);
        if (cookBuilding instanceof BuildingCook) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)cookBuilding.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ItemStackUtils.CAN_EAT, 2, (IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()));
            return EatingState.WAIT_FOR_FOOD;
        }
        return EatingState.IDLE;
    }

    private EatingState findPlaceToEat() {
        if (this.placeToPath == null) {
            Vec3d placeToEat = RandomPositionGenerator.func_191377_b((EntityCreature)this.citizen, (int)5, (int)0);
            if (placeToEat == null) {
                this.waitingTicks = 0;
                return EatingState.EAT;
            }
            this.placeToPath = new BlockPos(placeToEat);
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 5)) {
            this.waitingTicks = 0;
            return EatingState.EAT;
        }
        return EatingState.FIND_PLACE_TO_EAT;
    }

    private EatingState waitForFood(ICitizenData citizenData) {
        IColony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (this.placeToPath == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (BlockPosUtil.getDistance2D(this.placeToPath, this.citizen.func_180425_c()) > 5L) {
            return EatingState.GO_TO_RESTAURANT;
        }
        EatingState state = this.checkForFood(citizenData);
        if (state == EatingState.EAT) {
            return EatingState.FIND_PLACE_TO_EAT;
        }
        if (state == EatingState.IDLE) {
            this.reset();
            return EatingState.IDLE;
        }
        ++this.waitingTicks;
        if (this.waitingTicks > 120) {
            this.waitingTicks = 0;
            return EatingState.GET_FOOD_YOURSELF;
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToHut(ICitizenData data) {
        IBuildingWorker buildingWorker = data.getWorkBuilding();
        if (buildingWorker == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (this.citizen.isWorkerAtSiteWithMove(buildingWorker.getPosition(), 5)) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)buildingWorker, ItemStackUtils.CAN_EAT);
            if (slot != -1) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)buildingWorker.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ItemStackUtils.CAN_EAT, buildingWorker.getBuildingLevel() * 2, (IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()));
                return EatingState.CHECK_FOR_FOOD;
            }
            return EatingState.SEARCH_RESTAURANT;
        }
        return EatingState.GO_TO_HUT;
    }

    private EatingState goToRestaurant() {
        if (this.placeToPath == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 5)) {
            return EatingState.WAIT_FOR_FOOD;
        }
        return EatingState.SEARCH_RESTAURANT;
    }

    private EatingState searchRestaurant(ICitizenData citizenData) {
        IColony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestRestaurant(this.citizen);
        int uncookedFood = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, ItemStackUtils.ISCOOKABLE);
        boolean complained = false;
        if (uncookedFood != -1) {
            complained = true;
            citizenData.triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.wrongFood", new Object[0]), ChatPriority.PENDING));
        }
        if (this.placeToPath == null) {
            if (!complained) {
                citizenData.triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.noRestaurant", new Object[0]), ChatPriority.BLOCKING));
            }
            return EatingState.IDLE;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().resetAIAfterEating();
        }
        return EatingState.GO_TO_RESTAURANT;
    }

    private EatingState checkForFood(ICitizenData citizenData) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, ItemStackUtils.CAN_EAT);
        if (slot == -1) {
            citizenData.getCitizenHappinessHandler().setFoodModifier(false);
            if ((citizenData.getSaturation() < 3.0 || this.citizen.isIdlingAtJob()) && citizenData.getSaturation() < 7.0) {
                return EatingState.GO_TO_HUT;
            }
            this.reset();
            this.currentState = EatingState.IDLE;
            return EatingState.IDLE;
        }
        this.foodSlot = slot;
        return EatingState.EAT;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.foodSlot = -1;
        this.citizen.func_184597_cx();
        this.citizen.func_184602_cy();
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        this.placeToPath = null;
        this.currentState = EatingState.CHECK_FOR_FOOD;
    }

    public static enum EatingState {
        IDLE,
        CHECK_FOR_FOOD,
        GO_TO_HUT,
        SEARCH_RESTAURANT,
        GO_TO_RESTAURANT,
        WAIT_FOR_FOOD,
        GET_FOOD_YOURSELF,
        FIND_PLACE_TO_EAT,
        EAT;

    }
}

