/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.sifter;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.network.messages.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSifter
extends AbstractEntityAIInteract<JobSifter> {
    private static final int MAX_LEVEL = 50;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int ENDURANCE_MULTIPLIER = 2;
    private static final int TICK_DELAY = 10;
    private static final int CHANCE_TO_DUMP_INV = 10;
    protected int progress = 0;

    public EntityAIWorkSifter(@NotNull JobSifter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.SIFT, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.SIFT, 1), new AITarget((IAIState)AIWorkerState.SIFT, this::sift, 10));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingSifter.class;
    }

    private IAIState checkForSievableBlock(ItemStorage storage, BuildingSifter sifterBuilding) {
        Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(storage.getItemStack());
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), predicate)) {
            if (InventoryUtils.hasItemInProvider(sifterBuilding, predicate)) {
                this.needsCurrently = predicate;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int requestQty = Math.min((sifterBuilding.getDailyQuantity() - sifterBuilding.getCurrentDailyQuantity()) * 2, 64);
            if (requestQty <= 0) {
                return AIWorkerState.START_WORKING;
            }
            ItemStack stack2 = storage.getItemStack();
            stack2.func_190920_e(requestQty);
            this.checkIfRequestForItemExistOrCreate(stack2);
            return AIWorkerState.NEEDS_ITEM;
        }
        return this.getState();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    protected IAIState sift() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        WorkerUtil.faceBlock(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition(), this.worker);
        ++this.progress;
        BuildingSifter sifterBuilding = this.getOwnBuilding(BuildingSifter.class);
        if (InventoryUtils.isItemHandlerFull((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) {
            this.incrementActionsDone();
            return AIWorkerState.START_WORKING;
        }
        if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getDailyQuantity()) {
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.checkForSievableBlock(sifterBuilding.getSievableBlock(), sifterBuilding);
        if (this.progress > 50 - Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50)) {
            this.progress = 0;
            if (check == AIWorkerState.SIFT) {
                ItemStack result;
                sifterBuilding.setCurrentDailyQuantity(sifterBuilding.getCurrentDailyQuantity() + 1);
                if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getDailyQuantity() || this.worker.getRandom().nextInt(100) < 10) {
                    this.incrementActionsDoneAndDecSaturation();
                }
                if (!(result = IColonyManager.getInstance().getCompatibilityManager().getRandomSieveResultForMeshAndBlock((ItemStorage)sifterBuilding.getMesh().func_76341_a(), sifterBuilding.getSievableBlock())).func_190926_b()) {
                    InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), result);
                }
                InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)this.worker.getInventoryCitizen()), sifterBuilding.getSievableBlock().getItemStack());
                if (this.worker.getRandom().nextDouble() * 100.0 < (Double)sifterBuilding.getMesh().func_76340_b()) {
                    sifterBuilding.resetMesh();
                    this.worker.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.sifter.meshBroke", new Object[0]));
                }
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenExperienceHandler().addExperience(0.1);
                return AIWorkerState.START_WORKING;
            }
            return check;
        }
        if (check == AIWorkerState.SIFT) {
            MineColonies.getNetwork().sendToAllTracking((IMessage)new LocalizedParticleEffectMessage(((ItemStorage)sifterBuilding.getMesh().func_76341_a()).getItemStack().func_77946_l(), sifterBuilding.getID()), (Entity)this.worker);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new LocalizedParticleEffectMessage(sifterBuilding.getSievableBlock().getItemStack().func_77946_l(), sifterBuilding.getID().func_177977_b()), (Entity)this.worker);
            SoundUtils.playSoundAtCitizen(this.world, ((AbstractSchematicProvider)this.getOwnBuilding()).getID(), SoundEvents.field_187546_ae);
        }
        return this.getState();
    }
}

