/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.GuardArrow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIRanger
extends AbstractEntityAIGuard<JobRanger> {
    private static final int TIME_STRAFING_BEFORE_SWITCHING_DIRECTIONS = 4;
    private static final double SWITCH_STRAFING_DIRECTION = 0.3;
    private static final double STRAFING_SPEED = (double)0.7f;
    private boolean movingToTarget = false;
    private int strafingClockwise = 1;
    private int strafingTime = -1;
    private int timeAtSameSpot = 0;
    private int tooCloseNumTicks = 0;
    private boolean fleeing = false;
    public static final int RANGED_ATTACK_DELAY_BASE = 30;
    private PathResult fleePath;
    private int timeCanSee = 0;
    private double lastDistance = 0.0;

    public EntityAIRanger(@NotNull JobRanger job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_RANGED, this::attackRanged, 10));
        this.toolsNeeded.add(ToolType.BOW);
    }

    @Override
    public IAIState getAttackState() {
        this.strafingTime = 0;
        this.tooCloseNumTicks = 0;
        this.timeAtSameSpot = 0;
        this.timeCanSee = 0;
        this.fleeing = false;
        this.movingToTarget = false;
        return AIWorkerState.GUARD_ATTACK_RANGED;
    }

    @Override
    protected int getAttackRange() {
        return this.getRealAttackRange();
    }

    private int getRealAttackRange() {
        int attackDist = 5;
        if (this.buildingGuards != null) {
            attackDist += this.buildingGuards.getBuildingLevel();
        }
        if (this.worker.getCitizenData() != null) {
            attackDist = (int)((float)attackDist + (float)this.worker.getCitizenData().getLevel() / 50.0f * 15.0f);
        }
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (this.worker.field_70163_u - this.target.field_70163_u));
        }
        return attackDist > 24 ? 24 : attackDist;
    }

    @Override
    public boolean hasMainWeapon() {
        return !this.checkForToolOrWeapon(ToolType.BOW);
    }

    @Override
    public void wearWeapon() {
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.BOW, 0, this.buildingGuards.getMaxToolLevel());
        if (bowSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, bowSlot);
        }
    }

    protected IAIState attackRanged() {
        IAIState state = this.preAttackChecks();
        if (state != this.getState()) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.setDelay(5);
            return state;
        }
        if (this.worker.getCitizenData() == null) {
            return AIWorkerState.START_WORKING;
        }
        double sqDistanceToEntity = BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), this.target.func_180425_c());
        boolean canSee = this.worker.func_70635_at().func_75522_a((Entity)this.target);
        double sqAttackRange = this.getRealAttackRange() * this.getRealAttackRange();
        this.timeCanSee = canSee ? ++this.timeCanSee : --this.timeCanSee;
        this.timeAtSameSpot = this.lastDistance == sqDistanceToEntity ? ++this.timeAtSameSpot : 0;
        if (sqDistanceToEntity > sqAttackRange && this.timeAtSameSpot > 8 || !canSee && this.timeAtSameSpot > 8) {
            this.worker.getNavigator().func_75499_g();
            return AIWorkerState.DECIDE;
        }
        if (sqDistanceToEntity > sqAttackRange || !canSee) {
            if (this.worker.getNavigator().func_75500_f()) {
                this.moveInAttackPosition();
            }
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.movingToTarget = true;
            this.strafingTime = -1;
        } else if (this.movingToTarget && sqDistanceToEntity < sqAttackRange) {
            this.worker.getNavigator().func_75499_g();
            this.movingToTarget = false;
            this.strafingTime = -1;
        }
        if (this.fleeing && !this.fleePath.isComputing()) {
            this.fleeing = false;
            this.tooCloseNumTicks = 0;
        }
        if (sqDistanceToEntity < 5.0) {
            ++this.tooCloseNumTicks;
            this.strafingTime = -1;
            if (!this.fleeing && !this.movingToTarget && sqDistanceToEntity < 5.0 && this.tooCloseNumTicks > 5) {
                this.fleePath = this.worker.getNavigator().moveAwayFromEntityLiving((Entity)this.target, (double)this.getRealAttackRange() / 2.0, this.getCombatMovementSpeed());
                this.fleeing = true;
                this.worker.func_70605_aq().func_188488_a(0.0f, (float)this.strafingClockwise * 0.2f);
                this.strafingClockwise *= -1;
            }
        } else {
            this.tooCloseNumTicks = 0;
        }
        if (this.buildingGuards.getTask() != GuardTask.GUARD) {
            if (this.strafingTime >= 4) {
                if ((double)this.worker.func_70681_au().nextFloat() < 0.3) {
                    this.strafingClockwise *= -1;
                }
                this.strafingTime = 0;
            }
            if (sqDistanceToEntity < sqAttackRange / 2.0 && this.tooCloseNumTicks < 1) {
                ++this.strafingTime;
            } else if (sqDistanceToEntity > sqAttackRange / 2.0 + 5.0) {
                this.strafingTime = -1;
            }
            if (this.strafingTime > -1 && !this.fleeing && !this.movingToTarget) {
                this.worker.func_70605_aq().func_188488_a(0.0f, (float)(this.getCombatMovementSpeed() * (double)this.strafingClockwise * (double)0.7f));
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            } else {
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            }
        }
        if (this.worker.func_184587_cr()) {
            if (!canSee && this.timeCanSee < -6) {
                this.worker.func_184602_cy();
            } else if (canSee && sqDistanceToEntity <= sqAttackRange) {
                int k;
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                GuardArrow arrow = new GuardArrow(this.world, this.worker);
                double xVector = this.target.field_70165_t - this.worker.getPosX();
                double yVector = this.target.func_174813_aQ().field_72338_b + (double)this.target.field_70131_O / this.getAimHeight() - arrow.field_70163_u;
                double zVector = this.target.field_70161_v - this.worker.getPosZ();
                double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
                double damage = this.getRangedAttackDamage();
                ItemStack bow = this.worker.func_184586_b(EnumHand.MAIN_HAND);
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bow) > 0) {
                    arrow.func_70015_d(100);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                    arrow.func_70240_a(k);
                }
                double chance = 15.0 / (double)(this.worker.getCitizenData().getLevel() + 1);
                arrow.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
                if ((double)this.worker.func_110143_aJ() <= (double)this.worker.func_110138_aP() * 0.2) {
                    damage *= 2.0;
                }
                arrow.func_70239_b(damage);
                this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                this.worker.func_130014_f_().func_72838_d((Entity)arrow);
                double xDiff = this.target.field_70165_t - this.worker.getPosX();
                double zDiff = this.target.field_70161_v - this.worker.getPosZ();
                double goToX = xDiff > 0.0 ? 0.01 : -0.01;
                double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
                this.worker.func_70091_d(MoverType.SELF, goToX, 0.0, goToZ);
                this.timeCanSee = 0;
                this.target.func_70604_c((EntityLivingBase)this.worker);
                this.currentAttackDelay = this.getAttackDelay();
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
                this.worker.func_184602_cy();
                this.worker.decreaseSaturationForContinuousAction();
            } else if (this.target.field_70163_u > this.worker.getPosY() + 10.0 + 10.0) {
                this.fleePath = this.worker.getNavigator().moveAwayFromEntityLiving((Entity)this.target, 10.0, this.getCombatMovementSpeed());
                this.fleeing = true;
                this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            }
        } else {
            this.reduceAttackDelay(10);
            if (this.currentAttackDelay <= 0) {
                this.worker.func_184598_c(EnumHand.MAIN_HAND);
            }
        }
        this.lastDistance = sqDistanceToEntity;
        return AIWorkerState.GUARD_ATTACK_RANGED;
    }

    @Override
    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            int attackDelay = 30 - this.worker.getCitizenData().getLevel() / 2;
            return attackDelay < 20 ? 20 : attackDelay;
        }
        return 30;
    }

    private double getRangedAttackDamage() {
        if (this.worker.getCitizenData() != null) {
            int enchantDmg = 0;
            if (Configurations.gameplay.rangerEnchants) {
                ItemStack heldItem = this.worker.func_184586_b(EnumHand.MAIN_HAND);
                enchantDmg = (int)((double)enchantDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (EnumCreatureAttribute)this.target.func_70668_bt()) / 2.5);
                enchantDmg += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)heldItem);
            }
            return (double)(2 + this.getLevelDamage() + enchantDmg) * Configurations.gameplay.rangerDamageMult;
        }
        return 2.0 * Configurations.gameplay.rangerDamageMult;
    }

    private double getAimHeight() {
        return 3.0;
    }

    @Override
    public void moveInAttackPosition() {
        this.worker.getNavigator().tryMoveToBlockPos(this.worker.func_180425_c().func_177967_a(BlockPosUtil.getXZFacing(this.target.func_180425_c(), this.worker.func_180425_c()).func_176734_d(), 4), this.getCombatMovementSpeed());
    }
}

