/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.baker;

import com.minecolonies.coremod.entity.ai.citizen.baker.ProductState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class BakingProduct {
    private static final String TAG_STATE = "state";
    private static final String TAG_RECIPE_ID = "recipeId";
    private static final int FINISHED_BAKING_PROGRESS = 10;
    private final ItemStack endProduct;
    private final int recipeId;
    private ProductState state = ProductState.UNCRAFTED;
    private int bakingProgress = 0;

    public BakingProduct(@NotNull ItemStack endProduct, int recipeId) {
        this.endProduct = endProduct;
        this.recipeId = recipeId;
    }

    public static BakingProduct createFromNBT(NBTTagCompound productCompound) {
        if (productCompound.func_74764_b(TAG_STATE)) {
            ProductState state = ProductState.values()[productCompound.func_74762_e(TAG_STATE)];
            int recipeId = productCompound.func_74762_e(TAG_RECIPE_ID);
            BakingProduct bakingProduct = new BakingProduct(new ItemStack(productCompound), recipeId);
            bakingProduct.setState(state);
            return bakingProduct;
        }
        return null;
    }

    public ProductState getState() {
        return this.state;
    }

    private void setState(ProductState state) {
        this.state = state;
    }

    public ItemStack getEndProduct() {
        return this.endProduct;
    }

    public int getBakingProgress() {
        return this.bakingProgress;
    }

    public void increaseBakingProgress() {
        ++this.bakingProgress;
        if (this.bakingProgress >= 10) {
            this.nextState();
        }
    }

    public boolean nextState() {
        if (ProductState.values().length <= this.state.ordinal()) {
            return false;
        }
        this.state = ProductState.values()[this.state.ordinal() + 1];
        return true;
    }

    public int getRecipeId() {
        return this.recipeId;
    }

    public void writeToNBT(NBTTagCompound productCompound) {
        productCompound.func_74768_a(TAG_STATE, this.state.ordinal());
        productCompound.func_74768_a(TAG_RECIPE_ID, this.recipeId);
        this.endProduct.func_77955_b(productCompound);
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + this.endProduct.func_77955_b(new NBTTagCompound()).hashCode();
        result = 31 * result + this.recipeId;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BakingProduct)) {
            return false;
        }
        BakingProduct bakingProduct = (BakingProduct)o;
        if (this.recipeId != bakingProduct.recipeId) {
            return false;
        }
        if (this.state != bakingProduct.state) {
            return false;
        }
        return this.endProduct.equals(bakingProduct.endProduct);
    }
}

