/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.commands.citizencommands.AbstractCitizensCommands;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class SpawnCitizenCommand
extends AbstractCitizensCommands
implements IActionCommand {
    public static final String DESC = "spawn";
    private static final String CITIZEN_DESCRIPTION = "\u00a72ID: \u00a7f %d \u00a72 Name: \u00a7f %s";
    private static final String SPAWN_MESSAGE = "Has been spawned";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";

    public SpawnCitizenCommand() {
        super(new String[0]);
    }

    public SpawnCitizenCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <CitizenId>";
    }

    @Override
    public void executeSpecializedCode(@NotNull MinecraftServer server, ICommandSender sender, IColony colony, int citizenId) {
        if (SpawnCitizenCommand.isPlayerOpped(sender)) {
            colony.getCitizenManager().spawnOrCreateCitizen(null, colony.getWorld(), null, true);
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }

    @Override
    public AbstractSingleCommand.Commands getCommand() {
        return AbstractSingleCommand.Commands.SPAWNCITZENS;
    }

    @Override
    protected boolean requiresCitizen() {
        return false;
    }

    @Override
    public boolean canPlayerUseCommand(EntityPlayer player, AbstractSingleCommand.Commands theCommand, int colonyId) {
        World world = player.func_130014_f_();
        return super.canPlayerUseCommand(player, theCommand, colonyId) && IColonyManager.getInstance().getColonyByWorld(colonyId, world) != null && (IColonyManager.getInstance().getColonyByWorld(colonyId, world).getPermissions().getRank(player).equals((Object)Rank.OWNER) || IColonyManager.getInstance().getColonyByWorld(colonyId, world).getPermissions().getRank(player).equals((Object)Rank.OFFICER));
    }
}

