/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.AbstractSplitCommand;
import com.minecolonies.coremod.commands.CitizensCommand;
import com.minecolonies.coremod.commands.ColoniesCommand;
import com.minecolonies.coremod.commands.ColonyCommand;
import com.minecolonies.coremod.commands.DeleteCommand;
import com.minecolonies.coremod.commands.ISubCommand;
import com.minecolonies.coremod.commands.colonycommands.HomeTeleportCommand;
import com.minecolonies.coremod.commands.colonycommands.LoadColonyBackupCommand;
import com.minecolonies.coremod.commands.generalcommands.BackupCommand;
import com.minecolonies.coremod.commands.generalcommands.CheckForAutoDeletesCommand;
import com.minecolonies.coremod.commands.generalcommands.LootGenCommand;
import com.minecolonies.coremod.commands.generalcommands.RaidAllNowCommand;
import com.minecolonies.coremod.commands.generalcommands.RaidAllTonightCommand;
import com.minecolonies.coremod.commands.generalcommands.RandomTeleportCommand;
import com.minecolonies.coremod.commands.generalcommands.WhereAmICommand;
import com.minecolonies.coremod.commands.generalcommands.WhoAmICommand;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesCommand
extends AbstractSplitCommand {
    public static final String DESC = "minecolonies";
    private static final Map<UUID, Instant> commandExecutions = new HashMap<UUID, Instant>();
    private final ImmutableMap<String, ISubCommand> subCommands = new ImmutableMap.Builder().put((Object)"colonies", (Object)new ColoniesCommand("minecolonies")).put((Object)"kill", (Object)new DeleteCommand("minecolonies")).put((Object)"colony", (Object)new ColonyCommand("minecolonies")).put((Object)"citizens", (Object)new CitizensCommand("minecolonies")).put((Object)"rtp", (Object)new RandomTeleportCommand("minecolonies")).put((Object)"backup", (Object)new BackupCommand("minecolonies")).put((Object)"home", (Object)new HomeTeleportCommand("minecolonies")).put((Object)"loadBackup", (Object)new LoadColonyBackupCommand("minecolonies")).put((Object)"raid-tonight", (Object)new RaidAllTonightCommand("minecolonies")).put((Object)"raid-now", (Object)new RaidAllNowCommand("minecolonies")).put((Object)"check", (Object)new CheckForAutoDeletesCommand("minecolonies")).put((Object)"whoami", (Object)new WhoAmICommand("minecolonies")).put((Object)"whereami", (Object)new WhereAmICommand("minecolonies")).put((Object)"lootGen", (Object)new LootGenCommand("minecolonies")).build();

    public MinecoloniesCommand() {
        super(DESC);
    }

    public static boolean canExecuteCommand(@NotNull EntityPlayer player) {
        boolean canTeleport;
        if (Configurations.gameplay.teleportBuffer == 0 || AbstractSingleCommand.isPlayerOpped((ICommandSender)player)) {
            return true;
        }
        MinecoloniesCommand.cleanUpList();
        boolean bl = canTeleport = !commandExecutions.containsKey(player.func_110124_au());
        if (canTeleport) {
            commandExecutions.put(player.func_110124_au(), Instant.now());
        }
        return canTeleport;
    }

    private static void cleanUpList() {
        HashMap<UUID, Instant> mapCopy = new HashMap<UUID, Instant>(commandExecutions);
        for (Map.Entry entry : mapCopy.entrySet()) {
            if (!Instant.now().isAfter((Instant)entry.getValue()) || Instant.now().getEpochSecond() - ((Instant)entry.getValue()).getEpochSecond() <= (long)Configurations.gameplay.teleportBuffer) continue;
            commandExecutions.remove(entry.getKey());
        }
    }

    @Override
    public Map<String, ISubCommand> getSubCommands() {
        return this.subCommands;
    }
}

