/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.manager.RequestMappingHandler;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.IRequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedBlacklistAssignmentRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestHandler
implements IRequestHandler {
    private final IStandardRequestManager manager;

    public RequestHandler(IStandardRequestManager manager) {
        this.manager = manager;
    }

    @Override
    public IRequestManager getManager() {
        return this.manager;
    }

    @Override
    public <Request extends IRequestable> IRequest<Request> createRequest(IRequester requester, Request request) {
        IToken token = this.manager.getTokenHandler().generateNewToken();
        IRequest constructedRequest = (IRequest)this.manager.getFactoryController().getNewInstance(TypeToken.of((Class)((Class)RequestMappingHandler.getRequestableMappings().get(request.getClass()))), request, token, requester);
        this.manager.getLogger().debug("Creating request for: " + request + ", token: " + token + " and output: " + constructedRequest);
        this.registerRequest(constructedRequest);
        return constructedRequest;
    }

    @Override
    public void registerRequest(IRequest<?> request) {
        if (this.manager.getRequestIdentitiesDataStore().getIdentities().containsKey(request.getId()) || this.manager.getRequestIdentitiesDataStore().getIdentities().containsValue(request)) {
            throw new IllegalArgumentException("The given request is already known to this manager");
        }
        this.manager.getLogger().debug("Registering request: " + request);
        this.manager.getRequestIdentitiesDataStore().getIdentities().put(request.getId(), request);
    }

    @Override
    public void assignRequest(IRequest<?> request) {
        this.assignRequest(request, Collections.emptyList());
    }

    @Override
    public IToken<?> assignRequest(IRequest<?> request, Collection<IToken<?>> resolverTokenBlackList) {
        switch (request.getStrategy()) {
            case PRIORITY_BASED: {
                return this.assignRequestDefault(request, resolverTokenBlackList);
            }
            case FASTEST_FIRST: {
                MineColonies.getLogger().warn("Fastest First strategy not implemented yet.");
                return this.assignRequestDefault(request, resolverTokenBlackList);
            }
        }
        return null;
    }

    @Override
    public IToken<?> assignRequestDefault(IRequest request, Collection<IToken<?>> resolverTokenBlackList) {
        this.getRequest((IToken<?>)request.getId());
        this.manager.getLogger().debug("Starting resolver assignment search for request: " + request);
        request.setState(new WrappedStaticStateRequestManager(this.manager), RequestState.ASSIGNING);
        Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
        requestTypes.remove(TypeConstants.OBJECT);
        LinkedList<TypeToken> typeIndexList = new LinkedList<TypeToken>(requestTypes);
        Set resolvers = requestTypes.stream().filter(typeToken -> this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().containsKey(typeToken)).flatMap(type -> this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(type).stream().map(iToken -> this.manager.getResolverHandler().getResolver((IToken<?>)iToken))).filter(iRequestResolver -> typeIndexList.contains(iRequestResolver.getRequestType())).sorted(Comparator.comparingInt(r -> -1 * r.getPriority()).thenComparingInt(r -> typeIndexList.indexOf(r.getRequestType()))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (IRequestResolver resolver : resolvers) {
            List<IToken<?>> attemptResult;
            if (resolverTokenBlackList.contains(resolver.getId()) || !resolver.canResolveRequest(this.manager, request) || (attemptResult = resolver.attemptResolveRequest(new WrappedBlacklistAssignmentRequestManager(this.manager, resolverTokenBlackList), request)) == null) continue;
            this.manager.getLogger().debug("Finished resolver assignment search for request: " + request + " successfully");
            this.manager.getResolverHandler().addRequestToResolver(resolver, request);
            resolver.onRequestAssigned(this.manager, request, false);
            for (IToken<?> childRequestToken : attemptResult) {
                IRequest childRequest = this.manager.getRequestHandler().getRequest(childRequestToken);
                childRequest.setParent(request.getId());
                request.addChild(childRequest.getId());
                if (this.isAssigned(childRequestToken)) continue;
                this.assignRequest(childRequest, resolverTokenBlackList);
            }
            if (request.getState().ordinal() < RequestState.IN_PROGRESS.ordinal()) {
                request.setState(new WrappedStaticStateRequestManager(this.manager), RequestState.IN_PROGRESS);
                if (!request.hasChildren()) {
                    this.resolveRequest(request);
                }
            }
            return resolver.getId();
        }
        return null;
    }

    @Override
    public IToken<?> reassignRequest(IRequest<?> request, Collection<IToken<?>> resolverTokenBlackList) {
        if (request.hasChildren()) {
            throw new IllegalArgumentException("Can not reassign a request that has children.");
        }
        IRequestResolver<?> currentlyAssignedResolver = this.manager.getResolverForRequest((IToken<?>)request.getId());
        currentlyAssignedResolver.onAssignedRequestBeingCancelled(new WrappedStaticStateRequestManager(this.manager), request);
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(currentlyAssignedResolver.getId())) {
            this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(currentlyAssignedResolver.getId()).remove(request.getId());
            if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(currentlyAssignedResolver.getId()).isEmpty()) {
                this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(currentlyAssignedResolver.getId());
            }
        }
        currentlyAssignedResolver.onAssignedRequestCancelled(new WrappedStaticStateRequestManager(this.manager), request);
        this.manager.updateRequestState((IToken<?>)request.getId(), RequestState.REPORTED);
        IToken<?> newAssignedResolverId = this.assignRequest(request, resolverTokenBlackList);
        return newAssignedResolverId;
    }

    @Override
    public boolean isAssigned(IToken<?> token) {
        return this.manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(token) != null;
    }

    @Override
    public void onRequestResolved(IToken<?> token) {
        IRequest request = this.getRequest(token);
        IRequestResolver<? extends IRequestable> resolver = this.manager.getResolverHandler().getResolverForRequest(token);
        List<IRequest<?>> followupRequests = resolver.getFollowupRequestForCompletion(this.manager, request);
        request.setState(this.manager, RequestState.FOLLOWUP_IN_PROGRESS);
        if (followupRequests != null && !followupRequests.isEmpty()) {
            followupRequests.forEach(followupRequest -> request.addChild(followupRequest.getId()));
            followupRequests.forEach(followupRequest -> followupRequest.setParent(request.getId()));
        }
        if (followupRequests != null && !followupRequests.isEmpty() && followupRequests.stream().anyMatch(followupRequest -> !this.isAssigned((IToken<?>)followupRequest.getId()))) {
            followupRequests.stream().filter(followupRequest -> !this.isAssigned((IToken<?>)followupRequest.getId())).forEach(this::assignRequest);
        }
        if (!request.hasChildren()) {
            this.manager.updateRequestState((IToken<?>)request.getId(), RequestState.COMPLETED);
        }
    }

    @Override
    public void onRequestCompleted(IToken<?> token) {
        IRequest request = this.getRequest(token);
        request.getRequester().onRequestedRequestComplete(this.manager, request);
        if (request.hasParent()) {
            IRequest parentRequest = this.getRequest((IToken<?>)request.getParent());
            this.manager.updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED);
            parentRequest.removeChild(request.getId());
            request.setParent(null);
            if (!parentRequest.hasChildren()) {
                if (parentRequest.getState() == RequestState.IN_PROGRESS) {
                    this.resolveRequest(parentRequest);
                } else if (parentRequest.getState() == RequestState.FOLLOWUP_IN_PROGRESS) {
                    this.manager.updateRequestState((IToken<?>)parentRequest.getId(), RequestState.COMPLETED);
                }
            }
        }
    }

    @Override
    public void onRequestOverruled(IToken<?> token) {
        IRequest request = this.getRequest(token);
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(token) == null) {
            this.manager.getRequestIdentitiesDataStore().getIdentities().remove(token);
            return;
        }
        if (request.hasChildren()) {
            ImmutableCollection<IToken> currentChildren = request.getChildren();
            currentChildren.forEach(this::onRequestCancelledDirectly);
        }
        this.manager.getResolverHandler().getResolverForRequest(token).onAssignedRequestBeingCancelled(this.manager, request);
        this.manager.updateRequestState(token, RequestState.COMPLETED);
        this.manager.getResolverHandler().getResolverForRequest(token).onAssignedRequestCancelled(this.manager, request);
    }

    @Override
    public void onRequestCancelled(IToken<?> token) {
        IRequest request = this.manager.getRequestHandler().getRequest(token);
        if (request == null) {
            return;
        }
        if (request.hasParent()) {
            this.onChildRequestCancelled(token);
        } else {
            this.onRequestCancelledDirectly(token);
        }
        this.manager.markDirty();
    }

    @Override
    public void onChildRequestCancelled(IToken<?> token) {
        IRequest<?> request = this.manager.getRequestForToken(token);
        IRequest<?> parent = this.manager.getRequestForToken((IToken<?>)request.getParent());
        parent.getChildren().forEach(this::onRequestCancelledDirectly);
        this.reassignRequest(parent, (Collection<IToken<?>>)ImmutableList.of());
    }

    @Override
    public void onRequestCancelledDirectly(IToken<?> token) {
        IRequest<?> request = this.manager.getRequestForToken(token);
        if (request.hasChildren()) {
            request.getChildren().forEach(this::onRequestCancelledDirectly);
        }
        this.processDirectCancellationAndNotifyRequesterOf(request);
        this.cleanRequestData(token);
    }

    @Override
    public void processDirectCancellationAndNotifyRequesterOf(IRequest<?> request) {
        this.processDirectCancellationOf(request);
        request.getRequester().onRequestedRequestCancelled(this.manager, request);
    }

    @Override
    public void processDirectCancellationOf(IRequest<?> request) {
        IRequestResolver<?> resolver = this.manager.getResolverForRequest((IToken<?>)request.getId());
        resolver.onAssignedRequestBeingCancelled(new WrappedStaticStateRequestManager(this.manager), request);
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getId())) {
            this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).remove(request.getId());
            if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).isEmpty()) {
                this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolver.getId());
            }
        }
        if (request.hasParent()) {
            this.getRequest((IToken<?>)request.getParent()).removeChild(request.getId());
        }
        request.setParent(null);
        request.setState(this.manager, RequestState.CANCELLED);
        resolver.onAssignedRequestCancelled(new WrappedStaticStateRequestManager(this.manager), request);
    }

    @Override
    public void resolveRequest(IRequest request) {
        this.getRequest((IToken<?>)request.getId());
        if (!this.isAssigned((IToken<?>)request.getId())) {
            throw new IllegalArgumentException("The given request is not resolved");
        }
        if (request.getState() != RequestState.IN_PROGRESS) {
            throw new IllegalArgumentException("The given request is not in the right state. Required: " + (Object)((Object)RequestState.IN_PROGRESS) + " - Found:" + (Object)((Object)request.getState()));
        }
        if (request.hasChildren()) {
            throw new IllegalArgumentException("Cannot resolve request with open Children");
        }
        IRequestResolver<? extends IRequestable> resolver = this.manager.getResolverHandler().getResolverForRequest(request);
        request.setState(new WrappedStaticStateRequestManager(this.manager), RequestState.IN_PROGRESS);
        resolver.resolveRequest(this.manager, request);
    }

    @Override
    public void cleanRequestData(IToken<?> token) {
        this.manager.getLogger().debug("Removing " + token + " from the Manager as it has been completed and its package has been received by the requester.");
        this.getRequest(token);
        if (this.isAssigned(token)) {
            IRequestResolver<? extends IRequestable> resolver = this.manager.getResolverHandler().getResolverForRequest(token);
            this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).remove(token);
            if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).isEmpty()) {
                this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolver.getId());
            }
        }
        this.manager.getRequestIdentitiesDataStore().getIdentities().remove(token);
    }

    @Override
    public IRequest getRequest(IToken<?> token) {
        if (!this.manager.getRequestIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The given token is not registered as a request to this manager");
        }
        return this.getRequestOrNull(token);
    }

    @Override
    public IRequest getRequestOrNull(IToken<?> token) {
        this.manager.getLogger().debug("Retrieving the request for: " + token);
        return (IRequest)this.manager.getRequestIdentitiesDataStore().getIdentities().get(token);
    }

    @Override
    public Collection<IRequest<?>> getRequestsMadeByRequester(IRequester requester) {
        return this.manager.getRequestIdentitiesDataStore().getIdentities().values().stream().filter(iRequest -> iRequest.getRequester().getId().equals(requester.getId())).collect(Collectors.toList());
    }
}

