/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.IProviderHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class ProviderHandler
implements IProviderHandler {
    private final IStandardRequestManager manager;

    public ProviderHandler(IStandardRequestManager manager) {
        this.manager = manager;
    }

    @Override
    public IRequestManager getManager() {
        return this.manager;
    }

    @Override
    public Collection<IToken<?>> getRegisteredResolvers(IRequestResolverProvider provider) {
        Collection<IToken<?>> result = this.manager.getProviderResolverAssignmentDataStore().getAssignments().get(provider.getId());
        if (result == null) {
            return ImmutableList.of();
        }
        return result;
    }

    @Override
    public void registerProvider(IRequestResolverProvider provider) {
        ImmutableList.Builder resolverListBuilder = new ImmutableList.Builder();
        resolverListBuilder.addAll(this.manager.getResolverHandler().registerResolvers((Collection<IRequestResolver<?>>)provider.getResolvers()));
        this.manager.getProviderResolverAssignmentDataStore().getAssignments().put(provider.getId(), (Collection<ImmutableList>)resolverListBuilder.build());
        this.manager.getColony().markDirty();
    }

    @Override
    public void removeProvider(IToken<?> token) {
        this.removeProviderInternal(token);
    }

    @VisibleForTesting
    void removeProviderInternal(IToken<?> token) {
        this.manager.getLogger().info(String.format("Removing provider: %s", token));
        Collection<IToken<?>> assignedResolvers = this.getRegisteredResolvers(token);
        this.processResolversForRemoval(assignedResolvers);
        this.manager.getProviderResolverAssignmentDataStore().getAssignments().remove(token);
        this.manager.getColony().markDirty();
        this.manager.getLogger().debug(String.format("Removed provider: %s", token));
    }

    @VisibleForTesting
    void processResolversForRemoval(Collection<IToken<?>> assignedResolvers) {
        if (assignedResolvers != null && !assignedResolvers.isEmpty()) {
            for (IToken<?> resolverToken : assignedResolvers) {
                this.processResolverForRemoval(assignedResolvers, resolverToken);
            }
        }
    }

    @VisibleForTesting
    void processResolverForRemoval(Collection<IToken<?>> assignedResolvers, IToken<?> resolverToken) {
        Validate.isTrue((boolean)assignedResolvers.contains(resolverToken));
        if (!this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolverToken) || this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken).isEmpty()) {
            this.removeResolverWithoutAssignedRequests(resolverToken);
            return;
        }
        this.removeResolverWithAssignedRequests(assignedResolvers, resolverToken);
    }

    @VisibleForTesting
    void removeResolverWithoutAssignedRequests(@NotNull IToken<?> resolverToken) {
        this.manager.getLogger().debug("Removing resolver without assigned requests: " + resolverToken);
        this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolverToken);
        this.manager.getResolverHandler().removeResolver(resolverToken);
    }

    @VisibleForTesting
    void removeResolverWithAssignedRequests(@NotNull Collection<IToken<?>> assignedResolvers, IToken<?> resolverToken) {
        Validate.isTrue((boolean)assignedResolvers.contains(resolverToken));
        ArrayList assignedRequests = new ArrayList(this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken));
        this.manager.getLogger().debug("Starting reassignment of already registered requests registered to resolver with token: " + resolverToken);
        for (IToken requestToken : assignedRequests) {
            this.manager.reassignRequest(requestToken, assignedResolvers);
        }
        this.removeResolverWithoutAssignedRequests(resolverToken);
        this.manager.getLogger().debug("Finished reassignment of already registered requests registered to resolver with token: " + resolverToken);
    }

    @Override
    public Collection<IToken<?>> getRegisteredResolvers(@NotNull IToken<?> token) {
        Collection<IToken<?>> result = this.manager.getProviderResolverAssignmentDataStore().getAssignments().get(token);
        if (result == null) {
            return ImmutableList.of();
        }
        return result;
    }

    @Override
    public void removeProvider(@NotNull IRequestResolverProvider provider) {
        this.removeProviderInternal(provider.getId());
    }
}

