/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.sounds.BuilderSounds;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.builder.EntityAIStructureBuilder;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobBuilder
extends AbstractJobStructure {
    public JobBuilder(ICitizenData entity) {
        super(entity);
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.builder;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Builder";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.BUILDER;
    }

    @Override
    @NotNull
    public AbstractAISkeleton<JobBuilder> generateAI() {
        return new EntityAIStructureBuilder(this);
    }

    @Override
    @Nullable
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.hostile : null;
        }
        return null;
    }
}

