/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJob<AI extends AbstractAISkeleton<J>, J extends AbstractJob<AI, J>>
implements IJob<AI> {
    private static final String TAG_ASYNC_REQUESTS = "asyncRequests";
    private static final String TAG_ACTIONS_DONE = "actionsDone";
    private int actionsDone = 0;
    private static final int TASK_PRIORITY = 3;
    private final ICitizenData citizen;
    private String nameTag = "";
    private final Set<IToken> asyncRequests = new HashSet<IToken>();
    private boolean searchedForFoodToday;
    private WeakReference<AI> workerAI = new WeakReference<Object>(null);

    public AbstractJob(ICitizenData entity) {
        this.citizen = entity;
    }

    @Override
    public String getExperienceTag() {
        return this.getName();
    }

    @Override
    public IModelType getModel() {
        return BipedModelType.CITIZEN;
    }

    @Override
    public IColony getColony() {
        return this.citizen.getColony();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("type", this.getJobRegistryEntry().getRegistryName().toString());
        compound.func_74782_a(TAG_ASYNC_REQUESTS, (NBTBase)this.getAsyncRequests().stream().map(StandardFactoryController.getInstance()::serialize).collect(NBTUtils.toNBTTagList()));
        compound.func_74768_a(TAG_ACTIONS_DONE, this.actionsDone);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.asyncRequests.clear();
        if (compound.func_74764_b(TAG_ASYNC_REQUESTS)) {
            this.asyncRequests.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_ASYNC_REQUESTS, 10)).map(StandardFactoryController.getInstance()::deserialize).map(o -> (IToken)o).collect(Collectors.toSet()));
        }
        if (compound.func_74764_b(TAG_ACTIONS_DONE)) {
            this.actionsDone = compound.func_74762_e(TAG_ACTIONS_DONE);
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
    }

    @Override
    public Set<IToken> getAsyncRequests() {
        return this.asyncRequests;
    }

    @Override
    public void addWorkerAIToTaskList(@NotNull EntityAITasks tasks) {
        AbstractAISkeleton tempAI = (AbstractAISkeleton)((Object)this.generateAI());
        if (tempAI == null) {
            Log.getLogger().error("Failed to create AI for citizen!");
            if (this.citizen == null) {
                Log.getLogger().error("CitizenData is null for job: " + this.nameTag + " jobClass: " + this.getClass());
                return;
            }
            Log.getLogger().error("Affected Citizen name:" + this.citizen.getName() + " id:" + this.citizen.getId() + " job:" + this.citizen.getJob() + " jobForAICreation:" + this.nameTag + " class:" + this.getClass() + " entityPresent:" + this.citizen.getCitizenEntity().isPresent());
            return;
        }
        this.workerAI = new WeakReference<AbstractAISkeleton>(tempAI);
        tasks.func_75776_a(3, (EntityAIBase)tempAI);
    }

    @Override
    public boolean hasCheckedForFoodToday() {
        return this.searchedForFoodToday;
    }

    @Override
    public void setCheckedForFood() {
        this.searchedForFoodToday = true;
    }

    @Override
    public String getNameTagDescription() {
        return this.nameTag;
    }

    @Override
    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    @Override
    public SoundEvent getBedTimeSound() {
        return null;
    }

    @Override
    public SoundEvent getBadWeatherSound() {
        return null;
    }

    @Override
    public SoundEvent getMoveAwaySound() {
        return null;
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
    }

    @Override
    public boolean onStackPickUp(@NotNull ItemStack pickedUpStack) {
        if (this.getCitizen().getWorkBuilding() != null && this.getCitizen().getWorkBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l())) {
            return true;
        }
        if (this.getCitizen().getHomeBuilding() != null) {
            return this.getCitizen().getHomeBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l());
        }
        return false;
    }

    @Override
    public void onLevelUp(int newLevel) {
    }

    @Override
    public ICitizenData getCitizen() {
        return this.citizen;
    }

    @Override
    public void onWakeUp() {
        this.searchedForFoodToday = false;
    }

    @Override
    public boolean isOkayToEat() {
        return this.workerAI.get() != null && ((AbstractAISkeleton)((Object)this.workerAI.get())).getState().isOkayToEat();
    }

    @Override
    public int getActionsDone() {
        return this.actionsDone;
    }

    @Override
    public void incrementActionsDone() {
        ++this.actionsDone;
    }

    @Override
    public void clearActionsDone() {
        this.actionsDone = 0;
    }

    @Override
    public AI getWorkerAI() {
        return (AI)((Object)((AbstractAISkeleton)((Object)this.workerAI.get())));
    }

    @Override
    public boolean isIdling() {
        return this.workerAI.get() != null && ((AbstractAISkeleton)((Object)this.workerAI.get())).getState() == AIWorkerState.IDLE;
    }

    @Override
    public void resetAIAfterEating() {
        if (this.workerAI.get() != null) {
            ((AbstractAISkeleton)((Object)this.workerAI.get())).resetAI();
        }
    }

    @Override
    public boolean allowsAvoidance() {
        return true;
    }
}

