/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.configuration.NameConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteractionResponseHandler;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.coremod.network.messages.VanillaParticleMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenData
implements ICitizenData {
    private static final float MAX_HEALTH = 20.0f;
    private static final int LETTERS_IN_THE_ALPHABET = 26;
    private static final int MIN_SATURATION = 0;
    private static final int CHANCE_TO_LEVEL = 50;
    private static final int AMOUNT_OF_SKILLS = 5;
    private final int id;
    private final IColony colony;
    private final InventoryCitizen inventory;
    private String name;
    private boolean female;
    private boolean isChild = false;
    private boolean paused;
    private boolean restartScheduled;
    private EntityPlayerMP originPlayerRestart;
    private int textureId;
    private boolean isAsleep;
    private BlockPos bedPos = BlockPos.field_177992_a;
    @Nullable
    private IBuilding homeBuilding;
    @Nullable
    private IBuildingWorker workBuilding;
    private IJob job;
    private boolean dirty;
    private static final int MIN_STAT = 1;
    @NotNull
    private WeakReference<AbstractEntityCitizen> entity = new WeakReference<Object>(null);
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private double saturation;
    private boolean justAte;
    private Map<String, Tuple<Integer, Double>> levelExperienceMap = new HashMap<String, Tuple<Integer, Double>>();
    private BlockPos lastPosition = new BlockPos(0, 0, 0);
    private final CitizenHappinessHandler citizenHappinessHandler;
    private final Map<ITextComponent, IInteractionResponseHandler> citizenChatOptions = new HashMap<ITextComponent, IInteractionResponseHandler>();

    public CitizenData(int id, IColony colony) {
        this.id = id;
        this.colony = colony;
        this.inventory = new InventoryCitizen("Minecolonies Inventory", true, this);
        this.citizenHappinessHandler = new CitizenHappinessHandler(this);
    }

    @Override
    public void onResponseTriggered(@NotNull ITextComponent key, @NotNull ITextComponent response, World world) {
        if (this.citizenChatOptions.containsKey(key)) {
            this.citizenChatOptions.get(key).onServerResponseTriggered(response, world, this);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Optional<AbstractEntityCitizen> getCitizenEntity() {
        if (this.entity == null) {
            return Optional.empty();
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)((Object)this.entity.get());
        return Optional.ofNullable(citizen);
    }

    @Override
    public void setCitizenEntity(@Nullable AbstractEntityCitizen citizen) {
        if (this.entity.get() != null) {
            this.entity.clear();
        }
        if (citizen != null) {
            this.entity = new WeakReference<AbstractEntityCitizen>(citizen);
        }
    }

    @Override
    public void markDirty() {
        this.dirty = true;
        this.colony.getCitizenManager().markCitizensDirty();
    }

    private static String getRandomElement(@NotNull Random rand, @NotNull String[] array) {
        return array[rand.nextInt(array.length)];
    }

    private static char getRandomLetter(@NotNull Random rand) {
        return (char)(rand.nextInt(26) + 65);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitizenData data = (CitizenData)o;
        if (this.id != data.id) {
            return false;
        }
        return this.colony != null ? data.colony != null && this.colony.getID() == data.colony.getID() : data.colony == null;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void initForNewCitizen() {
        Random rand = new Random();
        this.female = rand.nextBoolean();
        this.paused = false;
        this.name = this.generateName(rand);
        this.saturation = 10.0;
        int levelCap = (int)this.colony.getOverallHappiness();
        if (levelCap <= 1) {
            this.intelligence = 1;
            this.charisma = 1;
            this.strength = 1;
            this.endurance = 1;
            this.dexterity = 1;
        } else {
            this.intelligence = rand.nextInt(levelCap - 1) + 1;
            this.charisma = rand.nextInt(levelCap - 1) + 1;
            this.strength = rand.nextInt(levelCap - 1) + 1;
            this.endurance = rand.nextInt(levelCap - 1) + 1;
            this.dexterity = rand.nextInt(levelCap - 1) + 1;
        }
        this.markDirty();
    }

    @Override
    public void initEntityValues() {
        if (!this.getCitizenEntity().isPresent()) {
            return;
        }
        AbstractEntityCitizen citizen = this.getCitizenEntity().get();
        citizen.setCitizenId(this.getId());
        citizen.getCitizenColonyHandler().setColonyId(this.getColony().getID());
        citizen.setIsChild(this.isChild());
        citizen.func_96094_a(citizen.getCitizenData().getName());
        citizen.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        citizen.setFemale(this.isFemale());
        citizen.setTextureId(this.getTextureId());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_COLONY_ID, (Object)this.colony.getID());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_CITIZEN_ID, (Object)citizen.getCitizenId());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_FEMALE, (Object)(citizen.isFemale() ? 1 : 0));
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_TEXTURE, (Object)citizen.getTextureId());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)this.isAsleep());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_CHILD, (Object)this.isChild());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)this.getBedPos());
        citizen.getCitizenExperienceHandler().updateLevel();
        this.setLastPosition(citizen.func_180425_c());
        citizen.getCitizenJobHandler().onJobChanged(citizen.getCitizenJobHandler().getColonyJob());
        this.markDirty();
    }

    private String generateName(@NotNull Random rand) {
        String firstName = this.female ? CitizenData.getRandomElement(rand, NameConfiguration.names.femaleFirstNames) : CitizenData.getRandomElement(rand, NameConfiguration.names.maleFirstNames);
        String middleInitial = String.valueOf(CitizenData.getRandomLetter(rand));
        String lastName = CitizenData.getRandomElement(rand, NameConfiguration.names.lastNames);
        String citizenName = NameConfiguration.names.useMiddleInitial ? String.format("%s %s. %s", firstName, middleInitial, lastName) : String.format("%s %s", firstName, lastName);
        for (ICitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen == null || !citizen.getName().equals(citizenName)) continue;
            citizenName = this.generateName(rand);
            break;
        }
        return citizenName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public void setIsFemale(@NotNull boolean isFemale) {
        this.female = isFemale;
        this.name = this.generateName(new Random());
        this.markDirty();
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
        this.markDirty();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public int getTextureId() {
        return this.textureId;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public void onRemoveBuilding(IBuilding building) {
        if (this.getHomeBuilding() == building) {
            this.setHomeBuilding(null);
        }
        if (this.getWorkBuilding() == building) {
            this.setWorkBuilding(null);
        }
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    public void setHomeBuilding(@Nullable IBuilding building) {
        if (this.homeBuilding != null && building != null && !this.homeBuilding.equals(building)) {
            this.homeBuilding.removeCitizen(this);
            this.markDirty();
        }
        this.homeBuilding = building;
        this.markDirty();
        if (this.getCitizenEntity().isPresent() && this.getCitizenEntity().get().getCitizenJobHandler().getColonyJob() == null) {
            this.getCitizenEntity().get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Override
    @Nullable
    public IBuildingWorker getWorkBuilding() {
        return this.workBuilding;
    }

    @Override
    public void setWorkBuilding(@Nullable IBuildingWorker building) {
        if (this.workBuilding != null && building != null && this.workBuilding != building) {
            Log.getLogger().warn("CitizenData.setWorkBuilding() - already assigned a work building when setting a new work building");
        } else if (this.workBuilding != building) {
            this.workBuilding = building;
            if (this.workBuilding != null) {
                if (this.job == null) {
                    this.setJob(this.workBuilding.createJob(this));
                    this.colony.getWorkManager().clearWorkForCitizen(this);
                }
            } else if (this.job != null) {
                this.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.getTasks().func_85156_a(((EntityAITasks.EntityAITaskEntry)entityCitizen.getTasks().field_75782_a.stream().filter((Predicate<EntityAITasks.EntityAITaskEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$0(net.minecraft.entity.ai.EntityAITasks$EntityAITaskEntry ), (Lnet/minecraft/entity/ai/EntityAITasks$EntityAITaskEntry;)Z)()).findFirst().orElse(null)).field_75733_a));
                this.setJob(null);
                this.colony.getWorkManager().clearWorkForCitizen(this);
            }
            this.markDirty();
        }
    }

    @Override
    public void updateCitizenEntityIfNecessary() {
        if (this.getCitizenEntity().isPresent()) {
            return;
        }
        this.colony.getCitizenManager().spawnOrCreateCitizen(this, this.colony.getWorld(), this.lastPosition, true);
    }

    @Override
    public IJob getJob() {
        return this.job;
    }

    @Override
    public void setJob(IJob job) {
        this.job = job;
        this.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.getCitizenJobHandler().onJobChanged(job));
        this.markDirty();
    }

    @Override
    @Nullable
    public <J extends IJob> J getJob(@NotNull Class<J> type) {
        if (type.isInstance(this.job)) {
            return (J)((IJob)type.cast(this.job));
        }
        return null;
    }

    @Override
    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeBoolean(this.female);
        buf.writeInt(this.getCitizenEntity().map(Entity::func_145782_y).orElse(-1).intValue());
        buf.writeBoolean(this.paused);
        buf.writeBoolean(this.isChild);
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.homeBuilding.getID());
        }
        buf.writeBoolean(this.workBuilding != null);
        if (this.workBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.workBuilding.getID());
        }
        buf.writeInt(this.getLevel());
        buf.writeDouble(this.getExperience());
        buf.writeFloat(this.getCitizenEntity().map(EntityLivingBase::func_110143_aJ).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeFloat(this.getCitizenEntity().map(EntityLivingBase::func_110138_aP).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeInt(this.getStrength());
        buf.writeInt(this.getEndurance());
        buf.writeInt(this.getCharisma());
        buf.writeInt(this.getIntelligence());
        buf.writeInt(this.getDexterity());
        buf.writeDouble(this.getSaturation());
        buf.writeDouble(this.citizenHappinessHandler.getHappiness());
        this.citizenHappinessHandler.serializeViewNetworkData(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.job != null ? this.job.getName() : ""));
        buf.writeInt(this.colony.getID());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        BlockPosUtil.writeToByteBuf(buf, this.lastPosition == null ? BlockPos.field_177992_a : this.lastPosition);
        if (this.colony.getWorld() != null) {
            List subInteractions = this.citizenChatOptions.values().stream().filter(e -> e.isVisible(this.colony.getWorld())).collect(Collectors.toList());
            buf.writeInt(subInteractions.size());
            for (IInteractionResponseHandler interactionHandler : subInteractions) {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)interactionHandler.serializeNBT()));
            }
        } else {
            buf.writeInt(0);
        }
    }

    @Override
    public int getLevel() {
        if (this.job == null) {
            return 0;
        }
        return (Integer)this.queryLevelExperienceMap().func_76341_a();
    }

    @Override
    public void setLevel(int lvl) {
        if (this.job == null) {
            return;
        }
        Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
        this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)lvl, entry.func_76340_b()));
        this.job.onLevelUp(lvl);
    }

    @Override
    public void addExperience(double xp) {
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple(entry.func_76341_a(), (Object)((Double)entry.func_76340_b() + xp)));
        }
    }

    @Override
    public void levelUp() {
        this.increaseLevel();
        if (this.getCitizenEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getCitizenEntity().get();
            MineColonies.getNetwork().sendToAllTracking((IMessage)new VanillaParticleMessage(citizen.field_70165_t, citizen.field_70163_u, citizen.field_70161_v, EnumParticleTypes.VILLAGER_HAPPY.func_179348_c()), (Entity)this.getCitizenEntity().get());
        }
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            this.job.onLevelUp((Integer)entry.func_76341_a());
        }
    }

    private void increaseLevel() {
        Tuple<Integer, Double> entry;
        if (this.job != null && (Integer)(entry = this.queryLevelExperienceMap()).func_76341_a() < 99) {
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)((Integer)entry.func_76341_a() + 1), entry.func_76340_b()));
        }
    }

    @Override
    public int getChanceToLevel() {
        return 50;
    }

    @Override
    public void increaseSaturation(double extraSaturation) {
        this.saturation = Math.min(10.0, this.saturation + Math.abs(extraSaturation));
    }

    @Override
    public void decreaseSaturation(double extraSaturation) {
        this.saturation = Math.max(0.0, this.saturation - Math.abs(extraSaturation * Configurations.gameplay.foodModifier));
        this.justAte = false;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getExperience() {
        if (this.job == null) {
            return 0.0;
        }
        return (Double)this.queryLevelExperienceMap().func_76340_b();
    }

    private Tuple<Integer, Double> queryLevelExperienceMap() {
        return this.levelExperienceMap.computeIfAbsent(this.job.getExperienceTag(), jobKey -> new Tuple((Object)0, (Object)0.0));
    }

    @Override
    public int getStrength() {
        return this.strength;
    }

    @Override
    public int getEndurance() {
        return this.endurance;
    }

    @Override
    public int getCharisma() {
        return this.charisma;
    }

    @Override
    public int getIntelligence() {
        return this.intelligence;
    }

    @Override
    public int getDexterity() {
        return this.dexterity;
    }

    @Override
    public void setLastPosition(BlockPos lastPosition) {
        this.lastPosition = lastPosition;
    }

    @Override
    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isAsleep() {
        return this.isAsleep;
    }

    @Override
    public BlockPos getBedPos() {
        return this.bedPos;
    }

    @Override
    public void setAsleep(boolean asleep) {
        this.isAsleep = asleep;
    }

    @Override
    public void setBedPos(BlockPos bedPos) {
        this.bedPos = bedPos;
    }

    @Override
    public <R extends IRequestable> IToken createRequest(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, false);
    }

    @Override
    public <R extends IRequestable> IToken createRequestAsync(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, true);
    }

    @Override
    public void onRequestCancelled(@NotNull IToken token) {
        if (this.isRequestAsync(token)) {
            this.job.getAsyncRequests().remove(token);
        }
    }

    @Override
    public boolean isRequestAsync(@NotNull IToken token) {
        if (this.job != null) {
            return this.job.getAsyncRequests().contains(token);
        }
        return false;
    }

    @Override
    public CitizenHappinessHandler getCitizenHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    @Override
    public void tryRandomLevelUp(Random random) {
        this.tryRandomLevelUp(random, 0);
    }

    @Override
    public void tryRandomLevelUp(Random random, int customChance) {
        if (customChance > 0 && random.nextInt(customChance) > 0 || customChance < 1 && random.nextInt(50) > 0) {
            return;
        }
        int levelCap = (int)this.getCitizenHappinessHandler().getHappiness();
        switch (random.nextInt(5)) {
            case 0: {
                this.intelligence = Math.max(this.intelligence, Math.min(this.intelligence + 1, levelCap));
                break;
            }
            case 1: {
                this.charisma = Math.max(this.charisma, Math.min(this.charisma + 1, levelCap));
                break;
            }
            case 2: {
                this.strength = Math.max(this.strength, Math.min(this.strength + 1, levelCap));
                break;
            }
            case 3: {
                this.endurance = Math.max(this.endurance, Math.min(this.endurance + 1, levelCap));
                break;
            }
            default: {
                this.dexterity = Math.max(this.dexterity, Math.min(this.dexterity + 1, levelCap));
            }
        }
        this.markDirty();
    }

    @Override
    public void scheduleRestart(EntityPlayerMP player) {
        this.originPlayerRestart = player;
        this.restartScheduled = true;
    }

    @Override
    public boolean shouldRestart() {
        return this.restartScheduled;
    }

    @Override
    public void restartDone() {
        this.restartScheduled = false;
        LanguageHandler.sendPlayerMessage((EntityPlayer)this.originPlayerRestart, "com.minecolonies.coremod.gui.hiring.restartMessageDone", this.getName());
    }

    @Override
    public void setIsChild(boolean isChild) {
        this.isChild = isChild;
        this.markDirty();
        if (this.colony != null) {
            this.colony.updateHasChilds();
        }
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public void setStrength(@NotNull int strength) {
        this.strength = strength < 1 ? 1 : ((double)strength > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : strength);
        this.markDirty();
    }

    @Override
    public void setEndurance(@NotNull int endurance) {
        this.endurance = endurance < 1 ? 1 : ((double)endurance > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : endurance);
        this.markDirty();
    }

    @Override
    public void setCharisma(@NotNull int charisma) {
        this.charisma = charisma < 1 ? 1 : ((double)charisma > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : charisma);
        this.markDirty();
    }

    @Override
    public void setIntelligence(@NotNull int intelligence) {
        this.intelligence = intelligence < 1 ? 1 : ((double)intelligence > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : intelligence);
        this.markDirty();
    }

    @Override
    public void setDexterity(@NotNull int dexterity) {
        this.dexterity = dexterity < 1 ? 1 : ((double)dexterity > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : dexterity);
        this.markDirty();
    }

    @Override
    public boolean justAte() {
        return this.justAte;
    }

    @Override
    public void setJustAte(boolean justAte) {
        this.justAte = justAte;
    }

    @Override
    public double drainExperience(int levelDrain) {
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            double drain = ExperienceUtils.getXPNeededForNextLevel(levelDrain - 1);
            double xpDrain = Math.min(drain, (Double)entry.func_76340_b());
            double newXp = (Double)entry.func_76340_b() - xpDrain / Configurations.gameplay.enchanterExperienceMultiplier;
            int newLevel = ExperienceUtils.calculateLevel(newXp);
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)newLevel, (Object)newXp));
            this.markDirty();
            return xpDrain;
        }
        return 0.0;
    }

    @Override
    public void spendLevels(int levelDrain) {
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            double drain = ExperienceUtils.getXPNeededForNextLevel(levelDrain - 1);
            double xpDrain = Math.min(drain, (Double)entry.func_76340_b());
            double newXp = (Double)entry.func_76340_b() - xpDrain;
            int newLevel = ExperienceUtils.calculateLevel(newXp);
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)newLevel, (Object)newXp));
            this.markDirty();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("id", this.id);
        nbtTagCompound.func_74778_a("name", this.name);
        nbtTagCompound.func_74757_a("female", this.female);
        nbtTagCompound.func_74757_a("paused", this.paused);
        nbtTagCompound.func_74757_a("child", this.isChild);
        nbtTagCompound.func_74768_a("texture", this.textureId);
        NBTTagList levelTagList = new NBTTagList();
        for (Map.Entry<String, Tuple<Integer, Double>> entry : this.levelExperienceMap.entrySet()) {
            NBTTagCompound levelCompound = new NBTTagCompound();
            levelCompound.func_74778_a("name", entry.getKey());
            levelCompound.func_74768_a("level", ((Integer)entry.getValue().func_76341_a()).intValue());
            levelCompound.func_74780_a("experience", ((Double)entry.getValue().func_76340_b()).doubleValue());
            levelTagList.func_74742_a((NBTBase)levelCompound);
        }
        nbtTagCompound.func_74782_a("levelMap", (NBTBase)levelTagList);
        BlockPosUtil.writeToNBT(nbtTagCompound, "pos", this.lastPosition);
        NBTTagCompound nbtTagSkillsCompound = new NBTTagCompound();
        nbtTagSkillsCompound.func_74768_a("strength", this.strength);
        nbtTagSkillsCompound.func_74768_a("endurance", this.endurance);
        nbtTagSkillsCompound.func_74768_a("charisma", this.charisma);
        nbtTagSkillsCompound.func_74768_a("intelligence", this.intelligence);
        nbtTagSkillsCompound.func_74768_a("dexterity", this.dexterity);
        nbtTagCompound.func_74782_a("skills", (NBTBase)nbtTagSkillsCompound);
        nbtTagCompound.func_74780_a("saturation", this.saturation);
        if (this.job != null) {
            NBTBase jobCompound = this.job.serializeNBT();
            nbtTagCompound.func_74782_a("job", jobCompound);
        }
        nbtTagCompound.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        nbtTagCompound.func_74768_a("HeldItemSlot", this.inventory.getHeldItemSlot(EnumHand.MAIN_HAND));
        nbtTagCompound.func_74768_a("OffhandHeldItemSlot", this.inventory.getHeldItemSlot(EnumHand.OFF_HAND));
        BlockPosUtil.writeToNBT(nbtTagCompound, "pos", this.bedPos);
        nbtTagCompound.func_74757_a("asleep", this.isAsleep);
        nbtTagCompound.func_74757_a("justAte", this.justAte);
        this.citizenHappinessHandler.writeToNBT(nbtTagCompound);
        NBTTagList chatTagList = new NBTTagList();
        for (IInteractionResponseHandler entry : this.citizenChatOptions.values()) {
            NBTTagCompound chatOptionCompound = new NBTTagCompound();
            chatOptionCompound.func_74782_a("chatoption", entry.serializeNBT());
            chatTagList.func_74742_a((NBTBase)chatOptionCompound);
        }
        nbtTagCompound.func_74782_a("chatoptions", (NBTBase)chatTagList);
        return nbtTagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbtTagCompound) {
        int i;
        this.name = nbtTagCompound.func_74779_i("name");
        this.female = nbtTagCompound.func_74767_n("female");
        this.paused = nbtTagCompound.func_74767_n("paused");
        this.isChild = nbtTagCompound.func_74767_n("child");
        this.textureId = nbtTagCompound.func_74762_e("texture");
        this.lastPosition = BlockPosUtil.readFromNBT(nbtTagCompound, "pos");
        NBTTagCompound nbtTagSkillsCompound = nbtTagCompound.func_74775_l("skills");
        this.strength = nbtTagSkillsCompound.func_74762_e("strength");
        this.endurance = nbtTagSkillsCompound.func_74762_e("endurance");
        this.charisma = nbtTagSkillsCompound.func_74762_e("charisma");
        this.intelligence = nbtTagSkillsCompound.func_74762_e("intelligence");
        this.dexterity = nbtTagSkillsCompound.func_74762_e("dexterity");
        this.saturation = nbtTagCompound.func_74769_h("saturation");
        if (nbtTagCompound.func_74764_b("job")) {
            this.setJob(IJobDataManager.getInstance().createFrom(this, nbtTagCompound.func_74775_l("job")));
        }
        if (nbtTagCompound.func_74764_b("levelMap")) {
            NBTTagList levelTagList = nbtTagCompound.func_150295_c("levelMap", 10);
            for (i = 0; i < levelTagList.func_74745_c(); ++i) {
                NBTTagCompound levelExperienceAtJob = levelTagList.func_150305_b(i);
                this.levelExperienceMap.put(levelExperienceAtJob.func_74779_i("name"), (Tuple<Integer, Double>)new Tuple((Object)Math.min(levelExperienceAtJob.func_74762_e("level"), 99), (Object)levelExperienceAtJob.func_74769_h("experience")));
            }
        } else if (this.job != null) {
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)nbtTagCompound.func_74762_e("level"), (Object)nbtTagCompound.func_74769_h("experience")));
        }
        if (nbtTagCompound.func_74764_b("inventory")) {
            NBTTagList nbttaglist = nbtTagCompound.func_150295_c("inventory", 10);
            this.inventory.readFromNBT(nbttaglist);
            this.inventory.setHeldItem(EnumHand.MAIN_HAND, nbtTagCompound.func_74762_e("HeldItemSlot"));
            this.inventory.setHeldItem(EnumHand.OFF_HAND, nbtTagCompound.func_74762_e("OffhandHeldItemSlot"));
        }
        if (this.name.isEmpty()) {
            this.name = this.generateName(new Random());
        }
        if (nbtTagCompound.func_74764_b("asleep")) {
            this.bedPos = BlockPosUtil.readFromNBT(nbtTagCompound, "pos");
            this.isAsleep = nbtTagCompound.func_74767_n("asleep");
        }
        if (nbtTagCompound.func_74764_b("justAte")) {
            this.justAte = nbtTagCompound.func_74767_n("justAte");
        }
        if (nbtTagCompound.func_74764_b("chatoptions")) {
            NBTTagList handlerTagList = nbtTagCompound.func_150295_c("chatoptions", 10);
            for (i = 0; i < handlerTagList.func_74745_c(); ++i) {
                ServerCitizenInteractionResponseHandler handler = (ServerCitizenInteractionResponseHandler)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, handlerTagList.func_150305_b(i).func_74775_l("chatoption"));
                this.citizenChatOptions.put(handler.getInquiry(), handler);
            }
        }
        this.citizenHappinessHandler.readFromNBT(nbtTagCompound);
    }

    @Override
    public void tick() {
        if (!this.getCitizenEntity().isPresent() || this.getCitizenEntity().get().isDead()) {
            return;
        }
        ArrayList<IInteractionResponseHandler> toRemove = new ArrayList<IInteractionResponseHandler>();
        for (IInteractionResponseHandler handler : this.citizenChatOptions.values()) {
            try {
                if (handler.isValid(this)) continue;
                toRemove.add(handler);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error during validation of handler: " + handler.getInquiry(), (Throwable)e);
                toRemove.add(handler);
            }
        }
        if (!toRemove.isEmpty()) {
            this.markDirty();
        }
        for (IInteractionResponseHandler handler : toRemove) {
            this.citizenChatOptions.remove(handler.getInquiry());
            for (ITextComponent comp : handler.getPossibleResponses()) {
                if (!this.citizenChatOptions.containsKey(handler.getResponseResult(comp))) continue;
                this.citizenChatOptions.get(handler.getResponseResult(comp)).removeParent(handler.getInquiry());
            }
        }
    }

    @Override
    public void triggerInteraction(@NotNull IInteractionResponseHandler handler) {
        if (!this.citizenChatOptions.containsKey(handler.getInquiry())) {
            this.citizenChatOptions.put(handler.getInquiry(), handler);
            for (IInteractionResponseHandler childHandler : handler.genChildInteractions()) {
                this.citizenChatOptions.put(childHandler.getInquiry(), (ServerCitizenInteractionResponseHandler)childHandler);
            }
            this.markDirty();
        }
    }

    private static /* synthetic */ boolean lambda$null$0(EntityAITasks.EntityAITaskEntry task) {
        return task.field_75733_a instanceof AbstractAISkeleton;
    }
}

