/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.Text;
import com.minecolonies.blockout.views.Box;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WindowInteraction
extends AbstractWindowSkeleton {
    private final ICitizenDataView citizen;
    private final List<IInteractionResponseHandler> interactions;
    private int currentInteraction = 0;

    public WindowInteraction(ICitizenDataView citizen) {
        super("minecolonies:gui/citizen/windowinteraction.xml");
        this.citizen = citizen;
        this.interactions = citizen.getOrderedInteractions();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setupInteraction();
    }

    private void setupInteraction() {
        if (this.interactions.size() <= this.currentInteraction) {
            WindowCitizen citizen = new WindowCitizen(this.citizen);
            citizen.open();
            return;
        }
        IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
        Box group = this.findPaneOfTypeByID("responseOptions", Box.class);
        int y = 0;
        int x = 0;
        this.findPaneOfTypeByID("chat", Text.class).setTextContent(this.citizen.getName() + ": " + handler.getInquiry().func_150254_d());
        for (ITextComponent component : handler.getPossibleResponses()) {
            ButtonImage button = new ButtonImage();
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
            button.setLabel(component.func_150254_d());
            button.setSize(129, 17);
            button.setTextColor(100);
            button.setPosition(x, y);
            group.addChild(button);
            if ((y += button.getHeight()) + button.getHeight() < group.getHeight()) continue;
            y = 0;
            x += 20 + button.getWidth();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (!this.interactions.isEmpty()) {
            IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
            for (ITextComponent component : handler.getPossibleResponses()) {
                if (!component.func_150254_d().equals(button.getLabel()) || !handler.onClientResponseTriggered(component, (World)Minecraft.func_71410_x().field_71441_e, this.citizen, this)) continue;
                ++this.currentInteraction;
                this.setupInteraction();
                return;
            }
        }
    }
}

