/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placementhandlers.IPlacementHandler;
import com.ldtteam.structurize.placementhandlers.PlacementHandlers;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class InstantStructurePlacer
extends com.ldtteam.structurize.util.InstantStructurePlacer {
    public InstantStructurePlacer(World worldObj, String name) {
        super(new Structure(worldObj, name, new PlacementSettings()));
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, boolean complete) {
        try {
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(worldObj, name);
            structureWrapper.structure.setPosition(pos);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.structure.setPlacementSettings(new PlacementSettings(mirror, BlockPosUtil.getRotationFromRotations(rotations)));
            structureWrapper.placeStructure(pos.func_177973_b((Vec3i)structureWrapper.structure.getOffset()), complete);
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not load structure! name:" + name, (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotate(BlockPosUtil.getRotationFromRotations(times), world, rotatePos, mirror);
    }

    private void placeStructure(@NotNull BlockPos pos, boolean complete) {
        this.structure.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !complete || localBlock instanceof AbstractBlockHut && !complete) continue;
                    if (localState.func_185904_a().func_76220_a()) {
                        this.handleBlockPlacement(worldPos, localState, complete, this.structure.getBlockInfo(localPos).getTileEntityData(), this.structure.getWorld());
                        continue;
                    }
                    delayedBlocks.add(localPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.handleBlockPlacement(newWorldPos, localState, complete, this.structure.getBlockInfo(coords).getTileEntityData(), this.structure.getWorld());
        }
        for (NBTTagCompound compound : this.structure.getEntityData()) {
            if (compound == null) continue;
            try {
                Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)this.structure.getWorld());
                entity.func_184221_a(UUID.randomUUID());
                Vec3d worldPos = entity.func_174791_d().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                entity.func_70107_b(worldPos.field_72450_a, worldPos.field_72448_b, worldPos.field_72449_c);
                this.structure.getWorld().func_72838_d(entity);
            }
            catch (RuntimeException e) {
                com.ldtteam.structurize.api.util.Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
            }
        }
    }

    private void handleBlockPlacement(BlockPos pos, IBlockState localState, boolean complete, NBTTagCompound tileEntityData, World world) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            if (!handlers.canHandle(world, pos, localState)) continue;
            Object result = handlers.handle(world, pos, localState, tileEntityData, complete, this.structure.getLocalPosition(), this.structure.getSettings());
            if (result instanceof IBlockState) {
                IBuilding building;
                IBlockState blockState = (IBlockState)result;
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
                if (colony != null && (building = colony.getBuildingManager().getBuilding(this.structure.getPosition())) != null) {
                    building.registerBlockPosition(blockState, pos, world);
                }
                return;
            }
            return;
        }
    }

    public static boolean tryToLoadAndPlaceSupplyCampWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            if (structureWrapper.checkForFreeSpace(pos)) {
                structureWrapper.placeStructure(pos, false);
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return false;
        }
    }
}

