/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.RecipeStorage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipeStorageFactory
extends IFactory<IToken, RecipeStorage> {
    @Override
    @NotNull
    default public RecipeStorage getNewInstance(@NotNull IFactoryController factoryController, @NotNull IToken token, Object ... context) {
        if (context.length < 3 || context.length > 4) {
            throw new IllegalArgumentException("Unsupported context - Not correct number of parameters. At least 3 at max 4 are needed.!");
        }
        if (!(context[0] instanceof List)) {
            throw new IllegalArgumentException("First parameter is supposed to be an Arraylist!");
        }
        if (!(context[1] instanceof Integer)) {
            throw new IllegalArgumentException("Second parameter is supposed to be an Integer!");
        }
        if (!(context[2] instanceof ItemStack)) {
            throw new IllegalArgumentException("Third parameter is supposed to be an ItemStack!");
        }
        if (context.length > 3 && !(context[3] instanceof Block)) {
            throw new IllegalArgumentException("Forth parameter is supposed to be a Block or Null!");
        }
        List input = (List)context[0];
        int gridSize = (Integer)context[1];
        ItemStack primaryOutput = (ItemStack)context[2];
        Block intermediate = context.length < 4 ? null : (Block)context[3];
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate);
    }

    @NotNull
    public RecipeStorage getNewInstance(@NotNull IToken var1, @NotNull List<ItemStack> var2, int var3, @NotNull ItemStack var4, @Nullable Block var5);
}

