/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.ICitizenAssignable;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuilding
extends ISchematicProvider,
ICitizenAssignable,
IBuildingContainer,
IRequestResolverProvider,
IRequester {
    @NotNull
    public String getCustomBuildingName();

    public void onWakeUp();

    public void onCleanUp(ICitizenData var1);

    public void onRestart(ICitizenData var1);

    public void onPlacement();

    public boolean isMatchingBlock(@NotNull Block var1);

    public void destroy();

    @Override
    public void onDestroyed();

    public boolean canBeBuiltByBuilder(int var1);

    @Override
    public void markDirty();

    public boolean hasWorkOrder();

    public void removeWorkOrder();

    public int getClaimRadius(int var1);

    public void serializeToView(@NotNull ByteBuf var1);

    public boolean isBeingGathered();

    public void setCustomBuildingName(String var1);

    public boolean canBeGathered();

    public void setBeingGathered(boolean var1);

    public void requestUpgrade(EntityPlayer var1, BlockPos var2);

    public void requestRepair(BlockPos var1);

    public boolean isBuilt();

    public void deconstruct();

    public void onUpgradeComplete(int var1);

    public int buildingRequiresCertainAmountOfItem(ItemStack var1, List<ItemStorage> var2, boolean var3);

    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount();

    @Nullable
    public ItemStack forceTransferStack(ItemStack var1, World var2);

    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData var1, @NotNull R var2, boolean var3);

    public <R extends IRequestable> IToken<?> createRequest(@NotNull R var1, boolean var2);

    public boolean hasWorkerOpenRequests(@NotNull ICitizenData var1);

    public ImmutableList<IRequest> getOpenRequests(@NotNull ICitizenData var1);

    public boolean hasWorkerOpenRequestsFiltered(@NotNull ICitizenData var1, @NotNull Predicate<IRequest> var2);

    public <R> boolean hasWorkerOpenRequestsOfType(@NotNull ICitizenData var1, TypeToken<R> var2);

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenData var1, TypeToken<R> var2);

    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData var1);

    public ImmutableList<IRequest> getCompletedRequests(@NotNull ICitizenData var1);

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData var1, TypeToken<R> var2);

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData var1, TypeToken<R> var2, Predicate<IRequest<? extends R>> var3);

    public void markRequestAsAccepted(@NotNull ICitizenData var1, @NotNull IToken<?> var2);

    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData var1);

    public void overruleNextOpenRequestWithStack(@NotNull ItemStack var1);

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData var1, TypeToken<R> var2, Predicate<IRequest<? extends R>> var3);

    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData var1, @NotNull ItemStack var2);

    @Override
    public ImmutableCollection<IRequestResolver<?>> getResolvers();

    public ImmutableCollection<IRequestResolver<?>> createResolvers();

    public IRequester getRequester();

    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken var1);

    public BuildingEntry getBuildingRegistryEntry();

    public boolean requiresCompleteRequestFulfillment();
}

