/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals;

import com.google.common.collect.Lists;
import divinerpg.DivineRPG;
import divinerpg.events.DimensionHelper;
import divinerpg.utils.PositionHelper;
import divinerpg.utils.Utils;
import divinerpg.utils.portals.WorkingPortalInfo;
import divinerpg.utils.portals.description.IPortalDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class ServerPortal
implements ITeleporter {
    protected final int radius;
    private final Map<DimensionType, List<WorkingPortalInfo>> activePortals;
    private final Map<DimensionType, List<WorkingPortalInfo>> activeOverworldPortals;
    protected int recheckDelay;

    public ServerPortal(int radius, int recheckDelay) {
        this.radius = radius;
        this.recheckDelay = recheckDelay;
        this.activePortals = new HashMap<DimensionType, List<WorkingPortalInfo>>();
        this.activeOverworldPortals = new HashMap<DimensionType, List<WorkingPortalInfo>>();
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        DimensionType destination;
        BlockPos entityPosition = entity.func_180425_c();
        DimensionType current = entity.func_130014_f_().field_73011_w.func_186058_p();
        DimensionType modDimension = destination = world.field_73011_w.func_186058_p();
        List cache = this.activePortals.computeIfAbsent(modDimension, x -> Lists.newArrayList());
        IPortalDescription description = DimensionHelper.descriptionsByDimension.get(destination);
        if (description == null) {
            description = DimensionHelper.descriptionsByDimension.get(current);
            modDimension = current;
            cache = this.activeOverworldPortals.computeIfAbsent(modDimension, x -> Lists.newArrayList());
        }
        if (description == null) {
            return;
        }
        BlockPattern.PatternHelper portalMatch = this.findFromCache(world, description, cache, entityPosition, this.radius * 2);
        if (portalMatch == null) {
            portalMatch = this.scanWorld(world, description, entityPosition.func_177982_a(-this.radius, -this.radius, -this.radius), entityPosition.func_177982_a(this.radius, this.radius, this.radius));
            if (portalMatch == null) {
                entityPosition = this.findSuitablePosition(world, description, entity, this.radius);
                portalMatch = description.createPortal(world, entityPosition);
            }
            if (portalMatch != null) {
                cache.add(new WorkingPortalInfo(world, entityPosition, portalMatch));
            }
        }
        if (portalMatch != null) {
            entityPosition = description.getPlayerPortalPosition(world, entity, portalMatch);
        } else {
            DivineRPG.logger.warn("Can't match portal on that cords: " + entityPosition.toString());
        }
        entity.func_70012_b((double)entityPosition.func_177958_n(), (double)entityPosition.func_177956_o(), (double)entityPosition.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)entityPosition.func_177958_n(), (double)entityPosition.func_177956_o(), (double)entityPosition.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
        }
        entity.field_71088_bW = entity.func_82147_ab();
    }

    @Nullable
    protected BlockPattern.PatternHelper findFromCache(World world, IPortalDescription description, List<WorkingPortalInfo> activePortals, BlockPos pos, int radius) {
        activePortals.removeIf(x -> !x.isWorking(world, description));
        WorkingPortalInfo info = activePortals.stream().filter(x -> x.canUse(pos, radius * 2)).findFirst().orElse(null);
        return info == null ? null : info.getMatch();
    }

    @Nullable
    protected BlockPattern.PatternHelper scanWorld(World world, IPortalDescription description, BlockPos min, BlockPos max) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos portalSize = description.getMaxSize();
        if (max.func_177956_o() > world.func_72800_K()) {
            max = new BlockPos(max.func_177958_n(), world.func_72800_K(), max.func_177952_p());
        }
        if (min.func_177956_o() < 0) {
            min = new BlockPos(min.func_177958_n(), 0, min.func_177952_p());
        }
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); x += portalSize.func_177958_n()) {
            for (int z = min.func_177952_p(); z <= max.func_177952_p(); z += portalSize.func_177952_p()) {
                for (int y = max.func_177956_o(); y >= min.func_177956_o(); y -= portalSize.func_177956_o()) {
                    pos.func_181079_c(x, y, z);
                    if (world.func_189509_E((BlockPos)pos)) continue;
                    for (BlockPos blockPos : description.checkChunk(world, (BlockPos)pos, pos.func_177971_a((Vec3i)portalSize))) {
                        BlockPattern.PatternHelper match = description.matchWorkingPortal(world, blockPos);
                        if (match == null) continue;
                        return match;
                    }
                }
            }
        }
        return null;
    }

    protected BlockPos findSuitablePosition(World destination, IPortalDescription description, Entity e, int radius) {
        BlockPos entityPosition = e.func_180425_c();
        BlockPos firstSolidBlock = PositionHelper.searchInRadius(destination, entityPosition, radius, blockPos -> {
            int y = Utils.getSurfaceBlockY(destination, blockPos.func_177958_n(), blockPos.func_177958_n());
            if (y < 0) {
                return false;
            }
            if (y != blockPos.func_177956_o()) {
                blockPos = new BlockPos(blockPos.func_177958_n(), y, blockPos.func_177952_p());
            }
            return destination.func_180495_p(blockPos).isSideSolid((IBlockAccess)destination, blockPos, EnumFacing.UP);
        });
        int possiblePosesCount = destination.field_73012_v.nextInt(60) + 10;
        ArrayList possiblePlaces = new ArrayList();
        BlockPos size = description.getMaxSize().func_177982_a(2, 2, 2);
        PositionHelper.searchInRadius(destination, firstSolidBlock, radius, blockPos -> {
            int y = Utils.getSurfaceBlockY(destination, blockPos.func_177958_n(), blockPos.func_177958_n());
            if (y <= 0) {
                return false;
            }
            if (y != blockPos.func_177956_o()) {
                blockPos = new BlockPos(blockPos.func_177958_n(), y, blockPos.func_177952_p());
            }
            if (destination.func_180495_p(blockPos).isSideSolid((IBlockAccess)destination, blockPos, EnumFacing.UP) && this.isAirBlocks(destination, new AxisAlignedBB(blockPos, blockPos.func_177971_a((Vec3i)size)))) {
                possiblePlaces.add(blockPos.func_185334_h());
            }
            return possiblePlaces.size() < possiblePosesCount;
        });
        if (!possiblePlaces.isEmpty()) {
            return (BlockPos)possiblePlaces.get(destination.field_73012_v.nextInt(possiblePlaces.size()));
        }
        BlockPos.func_177980_a((BlockPos)entityPosition.func_177982_a(-3, 0, -3), (BlockPos)entityPosition.func_177982_a(3, 5, 3)).forEach(arg_0 -> ((World)destination).func_175698_g(arg_0));
        return entityPosition;
    }

    protected boolean isAirBlocks(World world, AxisAlignedBB size) {
        AtomicBoolean result = new AtomicBoolean(true);
        BlockPos.func_191531_b((int)((int)size.field_72340_a), (int)((int)size.field_72338_b), (int)((int)size.field_72339_c), (int)((int)size.field_72336_d), (int)((int)size.field_72337_e), (int)((int)size.field_72334_f)).forEach(x -> {
            if (result.get() && !world.func_175623_d((BlockPos)x)) {
                result.set(false);
            }
        });
        return result.get();
    }
}

