/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.attributes;

import divinerpg.utils.attributes.IReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ReflectionHelper
implements IReflectionHelper {
    private final Map<Class<?>, Map<String, Field>> mappedFields = new LinkedHashMap();
    private final Map<Class<?>, Map<String, Method>> mappedMethods = new LinkedHashMap();

    @Override
    @Nullable
    public Field findField(Class<?> holderClass, String name) {
        if (holderClass != null && name != null) {
            Map classFields = this.mappedFields.computeIfAbsent(holderClass, aClass -> new LinkedHashMap());
            if (classFields.containsKey(name)) {
                return (Field)classFields.get(name);
            }
            String[] fieldNames = ObfuscationReflectionHelper.remapFieldNames((String)holderClass.getName(), (String[])new String[]{name});
            try {
                Field field = net.minecraftforge.fml.relauncher.ReflectionHelper.findField(holderClass, (String[])fieldNames);
                if (field != null) {
                    classFields.put(name, this.setAccessible(field));
                    return (Field)classFields.get(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Method findMethod(@Nonnull Class<?> holderClass, @Nonnull String name, Class ... params) {
        Object[] currentParams;
        Map map = this.mappedMethods.computeIfAbsent(holderClass, x -> new LinkedHashMap());
        Method method = (Method)map.get(name);
        if (method != null && Arrays.equals(currentParams = method.getParameterTypes(), params)) {
            return method;
        }
        String[] fieldNames = ObfuscationReflectionHelper.remapFieldNames((String)holderClass.getName(), (String[])new String[]{name});
        try {
            for (String fieldName : fieldNames) {
                Method findedMethod = net.minecraftforge.fml.relauncher.ReflectionHelper.findMethod(holderClass, (String)name, (String)fieldName, (Class[])params);
                if (findedMethod == null) continue;
                map.put(name, findedMethod);
                return findedMethod;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

