/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.vanilla;

import divinerpg.DivineRPG;
import divinerpg.enums.ParticleType;
import divinerpg.objects.entities.ai.AIDivineFireballAttack;
import divinerpg.objects.entities.entity.EntityDivineFlyingMob;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import java.util.Calendar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRainbour
extends EntityDivineFlyingMob {
    private int angerLevel;
    private UUID angerTargetUUID;

    public EntityRainbour(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    private void becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        if (target instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)target);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isAngry()) {
            return super.func_70652_k(entity);
        }
        return false;
    }

    public float func_70047_e() {
        return 0.6f;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70636_d() {
        super.func_70636_d();
        for (int var3 = 0; var3 < 8; ++var3) {
            DivineRPG.proxy.spawnParticle(this.field_70170_p, ParticleType.SPARKLER, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Override
    public boolean func_145773_az() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.RAINBOUR;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.RAINBOUR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.RAINBOUR_HURT;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_RAINBOUR;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() >= this.field_70170_p.func_181545_F()) {
            return false;
        }
        int lightLevel = this.field_70170_p.func_175671_l(blockpos);
        int minLightLevel = 4;
        Calendar calendar = this.field_70170_p.func_83015_S();
        if (!(calendar.get(2) == 9 && calendar.get(5) >= 20 || calendar.get(2) == 10 && calendar.get(5) <= 3)) {
            if (this.field_70146_Z.nextBoolean()) {
                return false;
            }
        } else {
            minLightLevel = 7;
        }
        return this.field_70170_p.field_73011_w.getDimension() == 0 && lightLevel <= this.field_70146_Z.nextInt(minLightLevel) && super.func_70601_bi();
    }

    @Override
    protected AIDivineFireballAttack createShootAI() {
        return null;
    }
}

