/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss;

import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.objects.entities.entity.projectiles.EntityLadyLunaSparkler;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.LootTableRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityLadyLuna
extends EntityDivineBoss {
    public ProtectionType protectionType;
    private int protectionTimer;
    private List<BlockPos> acidPositions = new ArrayList<BlockPos>();

    public EntityLadyLuna(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 3.5f);
        this.setRandomProtectionValues();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_LADY_LUNA;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 1.0f, 1.0f));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            for (int x = (int)this.field_70165_t - 2; x < (int)this.field_70165_t + 2; ++x) {
                for (int y = (int)this.func_174813_aQ().field_72338_b; y < (int)this.func_174813_aQ().field_72338_b + 4; ++y) {
                    for (int z = (int)this.field_70161_v - 2; z < (int)this.field_70161_v + 2; ++z) {
                        if (this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_185904_a() != Material.field_151584_j && this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_185904_a() != Material.field_151575_d) continue;
                        this.field_70170_p.func_175698_g(new BlockPos(x, y, z));
                    }
                }
            }
        }
        BlockPos current = new BlockPos((int)this.field_70165_t - 1, (int)this.field_70163_u, (int)this.field_70161_v - 1);
        BlockPos below = new BlockPos((int)this.field_70165_t - 1, (int)this.field_70163_u - 1, (int)this.field_70161_v - 1);
        IBlockState belowState = this.field_70170_p.func_180495_p(below);
        if (this.field_70170_p.func_180495_p(current).func_177230_c() == Blocks.field_150350_a && belowState.func_185914_p() && belowState.func_185917_h()) {
            this.field_70170_p.func_175656_a(current, BlockRegistry.lunicAcid.func_176223_P());
            this.acidPositions.add(current);
        }
        if (!this.field_70170_p.field_72995_K && this.getProtectionType() == ProtectionType.ARCANA && this.field_70173_aa % 30 == 0) {
            Iterator<BlockPos> iter = this.acidPositions.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != BlockRegistry.lunicAcid) {
                    iter.remove();
                    continue;
                }
                if (this.field_70146_Z.nextInt(4) != 0) continue;
                EntityLadyLunaSparkler e = new EntityLadyLunaSparkler(this.field_70170_p, (EntityLivingBase)this);
                e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 0, (double)pos.func_177952_p() + 0.5);
                this.field_70170_p.func_72838_d((Entity)e);
            }
        }
        if (this.getProtectionTimer() <= 0) {
            this.setRandomProtectionValues();
        } else if (this.getProtectionTimer() > 0) {
            this.setProtectionTimer(this.getProtectionTimer() - 1);
        }
    }

    public void setProtectionType(ProtectionType type) {
        if (type == ProtectionType.ARCANA) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        }
        this.protectionType = type;
    }

    public void setProtectionTimer(int i) {
        this.protectionTimer = i;
    }

    public ProtectionType getProtectionType() {
        return this.protectionType;
    }

    public int getProtectionTimer() {
        return this.protectionTimer;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_94541_c()) {
            return false;
        }
        ProtectionType type = this.getProtectionType();
        if (source.func_82725_o() && type == ProtectionType.ARCANA) {
            return false;
        }
        if ((source.func_76352_a() || source.field_76373_n.equals("thrown")) && type == ProtectionType.RANGED) {
            return false;
        }
        if (!source.func_76352_a() && !source.func_82725_o() && type == ProtectionType.MELEE) {
            return false;
        }
        return super.func_70097_a(source, par2);
    }

    public boolean func_70652_k(Entity e) {
        int dam = 20;
        boolean var4 = e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)dam);
        if (var4) {
            this.field_70170_p.func_72876_a((Entity)this, e.field_70165_t, e.field_70163_u, e.field_70161_v, 2.0f, false);
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
            int var5 = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (var5 > 0) {
                e.func_70015_d(var5 * 4);
            }
        }
        return var4;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        tag.func_74768_a("Immunity", this.getProtectionType().value());
        tag.func_74768_a("ImmunityCooldown", this.getProtectionTimer());
        return tag;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.setProtectionType(EntityLadyLuna.protectionTypeForInt(tag.func_74762_e("Immunity")));
        this.setProtectionTimer(tag.func_74762_e("ImmunityCooldown"));
    }

    private static ProtectionType protectionTypeForInt(int i) {
        switch (i) {
            case 0: {
                return ProtectionType.ARCANA;
            }
            case 1: {
                return ProtectionType.RANGED;
            }
            case 2: {
                return ProtectionType.MELEE;
            }
        }
        return null;
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    private void setRandomProtectionValues() {
        this.setProtectionType(EntityLadyLuna.protectionTypeForInt(this.field_70146_Z.nextInt(3)));
        this.setProtectionTimer(200 + this.field_70146_Z.nextInt(200));
    }

    public static enum ProtectionType {
        ARCANA(0),
        RANGED(1),
        MELEE(2);

        private int numVal;

        private ProtectionType(int numVal) {
            this.numVal = numVal;
        }

        public int value() {
            return this.numVal;
        }
    }
}

