/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.vanilla;

import divinerpg.objects.blocks.BlockModFluid;
import divinerpg.registry.BlockRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTar
extends BlockModFluid {
    private static final MapColor mapColor = MapColor.field_151646_E;

    public BlockTar(String name, Fluid fluid) {
        super(name, fluid, Material.field_151587_i);
        this.func_149675_a(true);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.checkForMixing(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_176213_c(worldIn, pos, state);
        this.checkForMixing(worldIn, pos, state);
    }

    public boolean checkForMixing(World worldIn, BlockPos pos, IBlockState state) {
        Integer integer;
        boolean touchingWater = false;
        boolean touchingLava = false;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            IBlockState adjacent = worldIn.func_180495_p(pos.func_177972_a(enumfacing));
            if (enumfacing != EnumFacing.DOWN && adjacent.func_185904_a() == Material.field_151586_h) {
                touchingWater = true;
                break;
            }
            if (enumfacing == EnumFacing.DOWN || adjacent.func_177230_c() == this || adjacent.func_185904_a() != Material.field_151587_i) continue;
            touchingLava = true;
            break;
        }
        if (touchingWater) {
            Integer integer2 = (Integer)state.func_177229_b((IProperty)LEVEL);
            if (integer2 == 0) {
                worldIn.func_175656_a(pos, BlockTar.fireFluidPlaceBlockEvent(worldIn, pos, pos, BlockRegistry.asphalt.func_176223_P()));
                this.triggerMixEffects(worldIn, pos);
                return true;
            }
            if (integer2 <= 4) {
                worldIn.func_175656_a(pos, BlockTar.fireFluidPlaceBlockEvent(worldIn, pos, pos, BlockRegistry.asphalt.func_176223_P()));
                this.triggerMixEffects(worldIn, pos);
                return true;
            }
        } else if (touchingLava && (integer = (Integer)state.func_177229_b((IProperty)LEVEL)) <= 4) {
            worldIn.func_175656_a(pos, BlockTar.fireFluidPlaceBlockEvent(worldIn, pos, pos, BlockRegistry.twilightStone.func_176223_P()));
            this.triggerMixEffects(worldIn, pos);
            return true;
        }
        return false;
    }

    protected void triggerMixEffects(World worldIn, BlockPos pos) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + Math.random(), d1 + 1.2, d2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        block7: {
            super.func_180650_b(world, pos, state, rand);
            if (this.field_149764_J != Material.field_151587_i || !world.func_82736_K().func_82766_b("doFireTick")) break block7;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if ((blockpos = blockpos.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177956_o() >= 0 && blockpos.func_177956_o() < world.func_72800_K() && !world.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState block = world.func_180495_p(blockpos);
                    if (block.func_177230_c().isAir(block, (IBlockAccess)world, blockpos)) {
                        if (!this.isSurroundingBlockFlammable(world, blockpos)) continue;
                        world.func_175656_a(blockpos, BlockTar.fireFluidPlaceBlockEvent(world, blockpos, pos, Blocks.field_150480_ab.func_176223_P()));
                        return;
                    }
                    if (!block.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (blockpos1.func_177956_o() >= 0 && blockpos1.func_177956_o() < 256 && !world.func_175667_e(blockpos1)) {
                        return;
                    }
                    if (!world.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn(world, blockpos1)) continue;
                    world.func_175656_a(blockpos1.func_177984_a(), BlockTar.fireFluidPlaceBlockEvent(world, blockpos1.func_177984_a(), pos, Blocks.field_150480_ab.func_176223_P()));
                }
            }
        }
    }

    public static IBlockState fireFluidPlaceBlockEvent(World world, BlockPos pos, BlockPos liquidPos, IBlockState state) {
        BlockEvent.FluidPlaceBlockEvent event = new BlockEvent.FluidPlaceBlockEvent(world, pos, liquidPos, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewState();
    }

    private boolean isSurroundingBlockFlammable(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World worldIn, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !worldIn.func_175667_e(pos) ? false : worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return mapColor;
    }
}

