/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.entity;

import com.google.common.collect.Lists;
import divinerpg.objects.blocks.tile.entity.base.ModUpdatableTileEntity;
import divinerpg.objects.entities.entity.boss.ayeraco.AyeracoGroup;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeraco;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoBlue;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoGreen;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoPurple;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoRed;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoYellow;
import divinerpg.registry.BlockRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileEntityAyeracoSpawn
extends ModUpdatableTileEntity
implements ITickable {
    private BlockPos greenBeam;
    private BlockPos blueBeam;
    private BlockPos redBeam;
    private BlockPos yellowBeam;
    private BlockPos purpleBeam;
    public int spawnTick = 600;

    public void func_73660_a() {
        switch (this.spawnTick) {
            case 600: {
                this.greenBeam = this.getBeamLocation(8, 8);
                this.blueBeam = this.getBeamLocation(15, 0);
                this.redBeam = this.getBeamLocation(5, -12);
                this.yellowBeam = this.getBeamLocation(-5, -12);
                this.purpleBeam = this.getBeamLocation(-8, 8);
                this.setBlock(this.greenBeam, BlockRegistry.ayeracoBeamGreen);
                this.logAyeracoSpawn(TextFormatting.GREEN);
                break;
            }
            case 430: {
                this.setBlock(this.blueBeam, BlockRegistry.ayeracoBeamBlue);
                this.logAyeracoSpawn(TextFormatting.BLUE);
                break;
            }
            case 300: {
                this.setBlock(this.redBeam, BlockRegistry.ayeracoBeamRed);
                this.logAyeracoSpawn(TextFormatting.RED);
                break;
            }
            case 210: {
                this.setBlock(this.yellowBeam, BlockRegistry.ayeracoBeamYellow);
                this.logAyeracoSpawn(TextFormatting.YELLOW);
                break;
            }
            case 145: {
                this.setBlock(this.purpleBeam, BlockRegistry.ayeracoBeamPurple);
                this.logAyeracoSpawn(TextFormatting.DARK_PURPLE, "purple");
                break;
            }
            case 0: {
                if (!this.field_145850_b.field_72995_K) {
                    ArrayList ayeracos = Lists.newArrayList((Object[])new EntityAyeraco[]{new EntityAyeracoRed(this.field_145850_b, this.redBeam), new EntityAyeracoGreen(this.field_145850_b, this.greenBeam), new EntityAyeracoBlue(this.field_145850_b, this.blueBeam), new EntityAyeracoYellow(this.field_145850_b, this.yellowBeam), new EntityAyeracoPurple(this.field_145850_b, this.purpleBeam)});
                    AyeracoGroup ayeracoGroup = new AyeracoGroup(ayeracos);
                    ayeracos.forEach(x -> x.initGroup(ayeracoGroup));
                    ayeracos.forEach(x -> this.field_145850_b.func_72838_d((Entity)x));
                }
                this.setBlock(this.field_174879_c, Blocks.field_150350_a);
                this.logAyeracoSpawn(TextFormatting.AQUA, "spawn");
            }
        }
        --this.spawnTick;
    }

    private BlockPos getBeamLocation(int x, int z) {
        BlockPos beamCoords = this.field_174879_c.func_177982_a(x, 0, z);
        if (this.field_145850_b.func_180495_p(beamCoords) == Blocks.field_150350_a.func_176223_P()) {
            while (beamCoords.func_177956_o() > 0 && this.field_145850_b.func_180495_p(beamCoords.func_177977_b()) == Blocks.field_150350_a.func_176223_P()) {
                beamCoords = beamCoords.func_177977_b();
            }
        } else {
            while (beamCoords.func_177956_o() < 200 && this.field_145850_b.func_180495_p(beamCoords) != Blocks.field_150350_a.func_176223_P()) {
                beamCoords = beamCoords.func_177984_a();
            }
        }
        return beamCoords;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.spawnTick = tag.func_74762_e("spawnTick");
        this.greenBeam = BlockPos.func_177969_a((long)tag.func_74763_f("greenBeam"));
        this.blueBeam = BlockPos.func_177969_a((long)tag.func_74763_f("blueBeam"));
        this.redBeam = BlockPos.func_177969_a((long)tag.func_74763_f("redBeam"));
        this.yellowBeam = BlockPos.func_177969_a((long)tag.func_74763_f("yellowBeam"));
        this.purpleBeam = BlockPos.func_177969_a((long)tag.func_74763_f("purpleBeam"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("spawnTick", this.spawnTick);
        if (this.greenBeam != null) {
            tag.func_74772_a("greenBeam", this.greenBeam.func_177986_g());
        }
        if (this.blueBeam != null) {
            tag.func_74772_a("blueBeam", this.blueBeam.func_177986_g());
        }
        if (this.redBeam != null) {
            tag.func_74772_a("redBeam", this.redBeam.func_177986_g());
        }
        if (this.yellowBeam != null) {
            tag.func_74772_a("yellowBeam", this.yellowBeam.func_177986_g());
        }
        if (this.purpleBeam != null) {
            tag.func_74772_a("purpleBeam", this.purpleBeam.func_177986_g());
        }
        return tag;
    }

    private void logAyeracoSpawn(TextFormatting formatting) {
        this.logAyeracoSpawn(formatting, null);
    }

    private void logAyeracoSpawn(TextFormatting formatting, String name) {
        if (this.field_145850_b.func_73046_m() != null) {
            if (name == null) {
                name = formatting.name().toLowerCase();
            }
            String langKey = "message.ayeraco." + name;
            this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().forEach(x -> {
                ITextComponent text = LocalizeUtils.getClientSideTranslation((ICommandSender)x, langKey, new Object[0]);
                text.func_150256_b().func_150238_a(formatting);
                x.func_145747_a(text);
            });
        }
    }

    private void setBlock(BlockPos pos, Block block) {
        this.field_145850_b.func_175656_a(pos, block.func_176223_P());
    }
}

