/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks;

import divinerpg.DivineRPG;
import divinerpg.enums.ParticleType;
import divinerpg.events.DimensionHelper;
import divinerpg.registry.DimensionRegistry;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.utils.portals.description.IPortalDescription;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModPortal
extends BlockBreakable {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    DimensionType dimId;
    ParticleType portalParticle;
    protected String name;
    private Supplier<Block> portalFrameSupplier;

    public static int meta(EnumFacing.Axis a) {
        return a == EnumFacing.Axis.X ? 1 : (a == EnumFacing.Axis.Z ? 2 : 0);
    }

    public BlockModPortal(String name, DimensionType dimId, Supplier<Block> fireBlockSupplier, Supplier<Block> portalFrameSupplier, ParticleType particle) {
        super(Material.field_151567_E, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.setRegistryName("divinerpg", name);
        this.func_149663_c(name);
        this.func_149675_a(true);
        this.func_149647_a(DivineRPGTabs.BLOCKS);
        this.func_149722_s();
        this.func_149672_a(Blocks.field_150427_aO.func_185467_w());
        this.dimId = dimId;
        this.portalFrameSupplier = portalFrameSupplier;
        this.portalParticle = particle;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public BlockFaceShape func_193383_a(IBlockAccess i, IBlockState i2, BlockPos p, EnumFacing f) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_176201_c(IBlockState state) {
        return BlockModPortal.meta((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IPortalDescription description = this.getPortalDescription();
        BlockPattern.PatternHelper helper = description.matchFrame(worldIn, pos);
        if (helper == null) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean canTransfer = entity.field_71088_bW <= 0;
        entity.field_71088_bW = 40;
        if (canTransfer) {
            DimensionType destination = this.dimId;
            if (worldIn.field_73011_w.func_186058_p() == destination) {
                destination = DimensionType.OVERWORLD;
            }
            if (this.dimId == DimensionRegistry.vetheaDimension) {
                DimensionHelper.transferEntity(entity, destination);
            } else {
                DimensionHelper.transferEntityToDivineDims(entity, destination);
            }
        }
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            DivineRPG.proxy.spawnParticle(worldIn, this.portalParticle, d0, d1, d2, d3, d4, d5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean flag5;
        pos = pos.func_177972_a(side);
        EnumFacing.Axis enumfacing$axis = null;
        if (blockState.func_177230_c() == this) {
            enumfacing$axis = (EnumFacing.Axis)blockState.func_177229_b(AXIS);
            if (enumfacing$axis == null) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean flag = blockAccess.func_180495_p(pos.func_177976_e()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag1 = blockAccess.func_180495_p(pos.func_177974_f()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag2 = blockAccess.func_180495_p(pos.func_177978_c()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag3 = blockAccess.func_180495_p(pos.func_177968_d()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag4 = flag || flag1 || enumfacing$axis == EnumFacing.Axis.X;
        boolean bl = flag5 = flag2 || flag3 || enumfacing$axis == EnumFacing.Axis.Z;
        if (flag4 && side == EnumFacing.WEST) {
            return true;
        }
        if (flag4 && side == EnumFacing.EAST) {
            return true;
        }
        if (flag5 && side == EnumFacing.NORTH) {
            return true;
        }
        return flag5 && side == EnumFacing.SOUTH;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    private IPortalDescription getPortalDescription() {
        IPortalDescription description = DimensionHelper.descriptionsByBlock.get(this.portalFrameSupplier.get());
        if (description == null) {
            throw new RuntimeException("Can't detect portal description for Divine portal for dimension :" + this.dimId.func_186065_b());
        }
        return description;
    }
}

