/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.wildwood;

import divinerpg.objects.blocks.BlockModSapling;
import divinerpg.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WildwoodTree
extends WorldGenAbstractTree {
    private int minTreeHeight;
    private boolean isSapling;

    public WildwoodTree(boolean notify) {
        this(notify, 5);
    }

    public WildwoodTree(boolean notify, int minTreeHeightIn) {
        super(notify);
        this.isSapling = notify;
        this.minTreeHeight = minTreeHeightIn;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        IBlockState log = BlockRegistry.wildwoodLog.func_176223_P();
        IBlockState leaves = BlockRegistry.wildwoodLeaves.func_176223_P();
        boolean isSoil = ((BlockModSapling)BlockRegistry.wildwoodSapling).func_176196_c(worldIn, position);
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        int treeTopPos = position.func_177956_o() + treeHeight;
        if (position.func_177956_o() < 1 || treeTopPos + 1 > 256 || !isSoil) {
            return false;
        }
        if (this.isSapling) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int iPosY = position.func_177956_o(); iPosY <= treeTopPos + 1; ++iPosY) {
                int k = iPosY > position.func_177956_o() + 1 ? 0 : (iPosY == position.func_177956_o() ? 2 : 1);
                int halflength = position.func_177958_n() + k;
                for (int iPosX = position.func_177958_n() - k; iPosX <= halflength + k; ++iPosX) {
                    int halfLength = position.func_177952_p() + k;
                    for (int iPosZ = position.func_177952_p() - k; iPosZ <= halfLength + k; ++iPosZ) {
                        if (iPosY >= 0 && iPosY < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableBlockPos.func_181079_c(iPosX, iPosY, iPosZ))) continue;
                            return false;
                        }
                        return false;
                    }
                }
            }
        }
        this.buildTrunk(worldIn, position, treeHeight, log, leaves);
        int i = rand.nextInt(treeHeight);
        for (int i2 = 0; i2 < i; ++i2) {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos = position.func_177981_b(i2);
            if (this.isAirLeaves(worldIn, blockpos)) {
                this.func_175903_a(worldIn, blockpos, log);
                if (i2 > 0) {
                    this.placeVine(worldIn, rand, blockpos.func_177976_e(), BlockVine.field_176278_M);
                    this.placeVine(worldIn, rand, blockpos.func_177978_c(), BlockVine.field_176279_N);
                }
            }
            if (i2 >= i - 1) continue;
            BlockPos blockpos1 = blockpos.func_177974_f();
            if (this.isAirLeaves(worldIn, blockpos1)) {
                this.func_175903_a(worldIn, blockpos1, log);
                if (i2 > 0) {
                    this.placeVine(worldIn, rand, blockpos1.func_177974_f(), BlockVine.field_176280_O);
                    this.placeVine(worldIn, rand, blockpos1.func_177978_c(), BlockVine.field_176279_N);
                }
            }
            if (this.isAirLeaves(worldIn, blockpos2 = blockpos.func_177968_d().func_177974_f())) {
                this.func_175903_a(worldIn, blockpos2, log);
                if (i2 > 0) {
                    this.placeVine(worldIn, rand, blockpos2.func_177974_f(), BlockVine.field_176280_O);
                    this.placeVine(worldIn, rand, blockpos2.func_177968_d(), BlockVine.field_176273_b);
                }
            }
            if (!this.isAirLeaves(worldIn, blockpos3 = blockpos.func_177968_d())) continue;
            this.func_175903_a(worldIn, blockpos3, log);
            if (i2 <= 0) continue;
            this.placeVine(worldIn, rand, blockpos3.func_177976_e(), BlockVine.field_176278_M);
            this.placeVine(worldIn, rand, blockpos3.func_177968_d(), BlockVine.field_176273_b);
        }
        return true;
    }

    private void placeVine(World world, Random rand, BlockPos pos, PropertyBool property) {
        if (!this.isSapling && rand.nextInt(3) > 0 && world.func_175623_d(pos)) {
            this.func_175903_a(world, pos, BlockRegistry.wildwoodVine.func_176223_P().func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean isAirLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }

    private void buildTrunk(World world, BlockPos pos, int treeHeight, IBlockState log, IBlockState leaves) {
        Random random = new Random();
        int rand = random.nextInt(1) + 1;
        int extraHeight = treeHeight + rand;
        this.func_175903_a(world, pos.func_177982_a(1, 1, 0), log);
        this.func_175903_a(world, pos.func_177982_a(0, 1, 1), log);
        this.func_175903_a(world, pos.func_177982_a(-1, 1, 0), log);
        this.func_175903_a(world, pos.func_177982_a(0, 1, -1), log);
        this.drawLeafCircle(world, pos.func_177982_a(0, 0, 0), 2, log);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight - 1, 0), 1, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight, 0), 2, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight + 1, 0), 1, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight + 2, 0), 0, leaves);
        for (int dy = 0; dy < extraHeight; ++dy) {
            this.func_175903_a(world, pos.func_177982_a(0, dy, 0), log);
        }
    }

    private void drawLeafCircle(World world, BlockPos pos, int rad, IBlockState leaves) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = (int)((double)Math.max(dx, dz) + (double)Math.min(dx, dz) * 0.5);
                if (dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dx == 0) {
                    if (dz < rad) {
                        this.func_175903_a(world, pos.func_177982_a(0, 0, dz), leaves);
                        this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), leaves);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(0, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), leaves);
                    continue;
                }
                if (dz == 0) {
                    if (dx < rad) {
                        this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), leaves);
                        this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), leaves);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), leaves);
                    continue;
                }
                if (dist < rad) {
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), leaves);
                    continue;
                }
                if (dist != rad) continue;
                this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), leaves);
            }
        }
    }
}

