/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei;

import divinerpg.DivineRPG;
import divinerpg.compat.jei.base.SmelterCategory;
import divinerpg.compat.jei.base.TripleRecipeWrapper;
import divinerpg.compat.jei.base.VillagerCategory;
import divinerpg.objects.blocks.tile.container.gui.ArcaniumExtractorGUI;
import divinerpg.objects.entities.container.gui.GuiCaptainMerik;
import divinerpg.objects.entities.container.gui.GuiDatticon;
import divinerpg.objects.entities.container.gui.GuiJackOMan;
import divinerpg.objects.entities.container.gui.GuiLeorna;
import divinerpg.objects.entities.container.gui.GuiLivestockMerchant;
import divinerpg.objects.entities.container.gui.GuiLordVatticus;
import divinerpg.objects.entities.container.gui.GuiWarGeneral;
import divinerpg.objects.entities.container.gui.GuiWorkshopMerchant;
import divinerpg.objects.entities.container.gui.GuiWorkshopTinkerer;
import divinerpg.objects.entities.container.gui.GuiZelus;
import divinerpg.registry.ArmorRegistry;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.ItemRegistry;
import divinerpg.registry.WeaponRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiJackOMan.MERCHANT_GUI_TEXTURE, "divinerpg:jack_o_man", LocalizeUtils.normal("entity.divinerpg.jack_o_man.name"), WeaponRegistry.scythe)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiWorkshopMerchant.MERCHANT_GUI_TEXTURE, "divinerpg:workshop_merchant", LocalizeUtils.normal("entity.divinerpg.workshop_merchant.name"), ArmorRegistry.santaHelmet)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiWorkshopTinkerer.MERCHANT_GUI_TEXTURE, "divinerpg:workshop_tinkerer", LocalizeUtils.normal("entity.divinerpg.workshop_tinkerer.name"), WeaponRegistry.frossivence)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiCaptainMerik.MERCHANT_GUI_TEXTURE, "divinerpg:capitain_meric", LocalizeUtils.normal("entity.divinerpg.captain_merik.name"), WeaponRegistry.starlight)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiLivestockMerchant.MERCHANT_GUI_TEXTURE, "divinerpg:livestock_merchant", LocalizeUtils.normal("entity.divinerpg.livestock_merchant.name"), ItemRegistry.shadowCoins)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiWarGeneral.MERCHANT_GUI_TEXTURE, "divinerpg:war_general", LocalizeUtils.normal("entity.divinerpg.war_general.name"), WeaponRegistry.arcaniteBlaster)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiLeorna.MERCHANT_GUI_TEXTURE, "divinerpg:leorna", LocalizeUtils.normal("entity.divinerpg.leorna.name"), ItemRegistry.firestockSeeds)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiDatticon.MERCHANT_GUI_TEXTURE, "divinerpg:datticon", LocalizeUtils.normal("entity.divinerpg.datticon.name"), new ItemStack(BlockRegistry.demonFurnace))});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiLordVatticus.MERCHANT_GUI_TEXTURE, "divinerpg:lord_vatticus", LocalizeUtils.normal("entity.divinerpg.lord_vatticus.name"), ItemRegistry.strongArcanaPotion)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VillagerCategory(guiHelper, GuiZelus.MERCHANT_GUI_TEXTURE, "divinerpg:zelus", LocalizeUtils.normal("entity.divinerpg.zelus.name"), ItemRegistry.golemOfRejuvenationEgg)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SmelterCategory(guiHelper, ArcaniumExtractorGUI.TEXTURES, "divinerpg:arcana_extractor", "Arcanium Extractor", new ItemStack(ItemRegistry.collector))});
    }

    public void register(IModRegistry registry) {
        DivineRPG.logger.info("Registering JEI compat");
        registry.addDescription(new ItemStack(BlockRegistry.rawArcanium), new String[]{"jeicompat." + BlockRegistry.rawArcanium.func_149739_a() + ".information"});
        registry.addRecipes(Arrays.asList(new TripleRecipeWrapper(new ItemStack(BlockRegistry.rawArcanium), new ItemStack(ItemRegistry.collector), new ItemStack(ItemRegistry.arcanium))), "divinerpg:arcana_extractor");
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.demonFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.greenlightFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.moltenFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.moonlightFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.whitefireFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.coalstoneFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.oceanfireFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlockRegistry.arcaniumExtractor), new String[]{"divinerpg:arcana_extractor"});
    }

    private void registerVillagerRecepies(IModRegistry registry, List<MerchantRecipe> receipes, String name) {
        registry.addRecipes((Collection)receipes.stream().map(TripleRecipeWrapper::new).collect(Collectors.toList()), name);
    }
}

