/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capabilities.armor;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.armor.IItemContainer;
import divinerpg.api.armor.binded.IPlayerArmorDescription;
import divinerpg.api.armor.cap.IArmorPowers;
import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.capabilities.armor.PlayerArmorDescription;
import divinerpg.networking.message.ArmorStatusChangedMessage;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class ArmorPowers
implements IArmorPowers {
    private final Map<ResourceLocation, IPlayerArmorDescription> descriptions = new LinkedHashMap<ResourceLocation, IPlayerArmorDescription>();
    private final WeakReference<EntityLivingBase> player;
    private boolean wasInitialized;

    public ArmorPowers() {
        this(null);
        DivineRPG.logger.warn("Should never get there");
        DivineRPG.logger.log(Level.DEBUG, (Object)Thread.currentThread().getStackTrace());
    }

    public ArmorPowers(EntityLivingBase player) {
        this.player = new WeakReference<EntityLivingBase>(player);
        if (player != null) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onCleanUp(EntityJoinWorldEvent e) {
        EntityLivingBase currentPlayer = (EntityLivingBase)this.player.get();
        if (currentPlayer == null) {
            this.unsubscribe();
            return;
        }
        if (e.getEntity() == currentPlayer) {
            if (!this.wasInitialized) {
                this.wasInitialized = true;
                if (currentPlayer.field_70170_p.field_72995_K) {
                    DivineRPG.network.sendToServer((IMessage)new ArmorStatusChangedMessage(new ResourceLocation(""), true));
                }
            }
            return;
        }
        if (Objects.equals(e.getEntity().func_110124_au(), currentPlayer.func_110124_au())) {
            return;
        }
        this.unsubscribe();
    }

    @Override
    public Set<ResourceLocation> wearing() {
        return this.descriptions.entrySet().stream().filter(x -> ((IPlayerArmorDescription)x.getValue()).isListening()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public void putOn(ResourceLocation id, boolean sendMessage) {
        this.changeWearStatus(id, true, sendMessage);
    }

    @Override
    public void takeOff(ResourceLocation id) {
        this.changeWearStatus(id, false, true);
    }

    @Override
    public Set<Item> currentItems(EntityEquipmentSlot slot) {
        HashSet<Item> items = new HashSet<Item>();
        if (this.player.get() != null) {
            ItemStack stack = ((EntityLivingBase)this.player.get()).func_184582_a(slot);
            items.add(stack.func_77973_b());
            if (stack.func_77973_b() instanceof IItemContainer) {
                items.addAll(((IItemContainer)stack.func_77973_b()).getItems(stack));
            }
        }
        return items;
    }

    @Nullable
    private void changeWearStatus(ResourceLocation id, boolean isOn, boolean sendMessage) {
        IPlayerArmorDescription description;
        if (this.player.get() != null && (description = this.descriptions.computeIfAbsent(id, location -> {
            IArmorDescription value = (IArmorDescription)DivineAPI.getArmorDescriptionRegistry().getValue(id);
            return value == null ? null : new PlayerArmorDescription((EntityLivingBase)this.player.get(), value);
        })) != null) {
            description.changeStatus(isOn, sendMessage);
        }
    }

    private void unsubscribe() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.descriptions.values().forEach(IPlayerArmorDescription::unsubscribe);
        this.descriptions.clear();
    }
}

