/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.api;

import divinerpg.api.DivineAPI;
import divinerpg.api.armor.cap.IArmorPowers;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ArmorHandlers {
    private static final UUID ARMOR_SPEED_UUID = UUID.fromString("2ae05d96-4b26-420b-8406-156e8febb45f");

    public static void onCanFlyChanged(EntityLivingBase entity, boolean canFly) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71075_bZ.field_75098_d || canFly == player.field_71075_bZ.field_75101_c) {
            return;
        }
        player.field_71075_bZ.field_75101_c = canFly;
        if (!canFly && player.field_71075_bZ.field_75100_b) {
            player.field_71075_bZ.field_75100_b = false;
        }
        player.func_71016_p();
    }

    public static void onAddMeleeDamage(LivingHurtEvent e, Function<Float, Float> damageConversionFunc) {
        ArmorHandlers.onPlayerAttacked(e, ArmorHandlers::isMeeleeDamage, damageConversionFunc);
    }

    public static void onAddRangedDamage(LivingHurtEvent e, Function<Float, Float> damageConversionFunc) {
        ArmorHandlers.onPlayerAttacked(e, DamageSource::func_76352_a, damageConversionFunc);
    }

    public static void onAddRangedDamage(LivingHurtEvent e, ResourceLocation armorId, Function<Float, Float> damageConversionFunc) {
        if (ArmorHandlers.isRemote(e.getEntity()) || !(e.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        DamageSource source = e.getSource();
        Entity entity = source.func_76346_g();
        IArmorPowers powers = DivineAPI.getArmorPowers(entity);
        if (powers != null && (source.func_76352_a() || source.func_76355_l().equals("thrown")) && powers.wearing(armorId)) {
            e.setAmount(damageConversionFunc.apply(Float.valueOf(e.getAmount())).floatValue());
        }
    }

    public static void onPlayerAttacked(LivingHurtEvent e, Function<DamageSource, Boolean> canApply, Function<Float, Float> damageConversionFunc) {
        DamageSource source = e.getSource();
        if (!(source.func_76346_g() instanceof EntityPlayer) || !canApply.apply(source).booleanValue()) {
            return;
        }
        e.setAmount(damageConversionFunc.apply(Float.valueOf(e.getAmount())).floatValue());
    }

    public static void onCancelPlayerReceiveDamage(LivingHurtEvent e, Function<DamageSource, Boolean> canApply) {
        ArmorHandlers.onPlayerReceiveDamage(e, canApply, aFloat -> Float.valueOf(0.0f));
    }

    public static void refillHunger(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        if (!ArmorHandlers.isRemote((Entity)player) && player.func_71024_bL().func_75121_c()) {
            player.func_71024_bL().func_75122_a(1, 0.0f);
        }
    }

    public static void onPlayerReceiveDamage(LivingHurtEvent e, Function<DamageSource, Boolean> canApply, Function<Float, Float> damageConversionFunc) {
        DamageSource source = e.getSource();
        if (!(e.getEntity() instanceof EntityPlayer) || ArmorHandlers.isRemote(e.getEntity()) || !canApply.apply(source).booleanValue()) {
            return;
        }
        Float damage = damageConversionFunc.apply(Float.valueOf(e.getAmount()));
        if (damage.floatValue() <= 0.0f) {
            e.setCanceled(true);
        } else {
            e.setAmount(damage.floatValue());
        }
    }

    public static void speedUpPlayer(EntityLivingBase player, float speedMultiplier, boolean force) {
        ArmorHandlers.speedUpAttribute(player, SharedMonsterAttributes.field_111263_d, speedMultiplier, force, isRemove -> {
            if (player.field_70170_p.field_72995_K) {
                player.field_70138_W = isRemove != false ? 0.6f : 1.625f;
            }
        });
    }

    public static void removeSpeed(EntityLivingBase player) {
        ArmorHandlers.speedUpPlayer(player, -1.0f, true);
    }

    public static void frozeNearMobs(TickEvent.PlayerTickEvent e, int skipTicks, int radius) {
        EntityPlayer player = e.player;
        World world = player.field_70170_p;
        if (ArmorHandlers.isRemote((Entity)player) || world.func_82737_E() % (long)skipTicks != 0L) {
            return;
        }
        List entities = player.field_70170_p.func_72872_a(EntityMob.class, player.func_174813_aQ().func_186662_g((double)radius));
        for (Entity mob : entities) {
            ((EntityMob)mob).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 1, true, true));
        }
    }

    public static void speedUpInWater(EntityLivingBase player, float speedMultiplier, boolean forced) {
        ArmorHandlers.speedUpAttribute(player, EntityPlayer.SWIM_SPEED, speedMultiplier, forced, null);
    }

    private static void speedUpAttribute(EntityLivingBase player, IAttribute attr, float speedMultiplier, boolean forced, Consumer<Boolean> callBack) {
        boolean isRemove;
        IAttributeInstance attribute = player.func_110148_a(attr);
        if (attribute == null) {
            return;
        }
        AttributeModifier modifier = attribute.func_111127_a(ARMOR_SPEED_UUID);
        boolean bl = isRemove = (speedMultiplier = (float)((double)speedMultiplier * attribute.func_111125_b() - attribute.func_111125_b())) < 0.0f;
        if (forced || modifier == null || modifier.func_111164_d() < (double)speedMultiplier) {
            attribute.func_188479_b(ARMOR_SPEED_UUID);
            if (!isRemove) {
                modifier = new AttributeModifier(ARMOR_SPEED_UUID, "Armor speed modifier", (double)speedMultiplier, 0);
                attribute.func_111121_a(modifier);
            }
            if (callBack != null) {
                callBack.accept(isRemove);
            }
        }
    }

    public static void disableFallDamage(LivingFallEvent event) {
        event.setDistance(0.0f);
    }

    public static void breatheUnderwater(TickEvent.PlayerTickEvent event) {
        if (!ArmorHandlers.isRemote((Entity)event.player) && event.player.field_70170_p.func_82737_E() % 30L == 0L) {
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 40, 0, true, false));
        }
    }

    public static boolean isMeeleeDamage(DamageSource source) {
        return !source.func_94541_c() && !source.func_82725_o() && !source.func_76347_k() && !source.func_76352_a() && !source.func_151517_h() && !source.func_76363_c();
    }

    public static void getStepAssist(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            event.getEntityLiving().field_70138_W = 1.0f;
        }
    }

    private static boolean isRemote(Entity e) {
        return e == null || e.field_70170_p.field_72995_K;
    }
}

