/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.advmachinespatch.asm;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AClassTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"AdvMachinesPatchCoreMod");
    private static final Map<String, String> REPLACEMENTS = new HashMap<String, String>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.contains("com.chocohead.AdvMachines.te.TileEntityHeatingMachine")) {
            return this.patchTileEntityHeatingMachine(bytes);
        }
        if (name.equals("com.chocohead.AdvMachines.AdvancedMachines")) {
            return this.patchAdvancedMachines(bytes);
        }
        return bytes;
    }

    private byte[] patchAdvancedMachines(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        LOGGER.info("Patching class AdvancedMachines");
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode m : classNode.methods) {
            if (!m.name.equals("init") || !m.desc.equals("(Lnet/minecraftforge/fml/common/event/FMLInitializationEvent;)V")) continue;
            ListIterator it = m.instructions.iterator();
            boolean addedSkip = false;
            LabelNode skipTo = new LabelNode();
            while (it.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)it.next();
                if (!addedSkip && insn instanceof LdcInsnNode && ((LdcInsnNode)insn).cst.equals("ore_washing_plant")) {
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(167, skipTo));
                    addedSkip = true;
                    continue;
                }
                if (!addedSkip || !(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals("com/chocohead/AdvMachines/AdvancedMachines") || !((MethodInsnNode)insn).name.equals("addRecipe")) continue;
                m.instructions.insert(insn, (AbstractInsnNode)skipTo);
                break block0;
            }
            break block0;
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        LOGGER.info("Class AdvancedMachines patched successfully!");
        return cw.toByteArray();
    }

    private byte[] patchTileEntityHeatingMachine(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        LOGGER.info("Patching class TileEntityHeatingMachine");
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("<init>") || !m.desc.equals("(BBLic2/api/recipe/IMachineRecipeManager;II)V")) continue;
            block1: for (AbstractInsnNode insn : m.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode mInsn = (MethodInsnNode)insn;
                for (Map.Entry<String, String> entry : REPLACEMENTS.entrySet()) {
                    if (!mInsn.owner.equals(entry.getKey()) || !mInsn.name.equals("<init>") || !mInsn.desc.equals(entry.getValue())) continue;
                    mInsn.desc = mInsn.desc.replace("ic2/core/block/TileEntityInventory", "ic2/core/block/IInventorySlotHolder");
                    continue block1;
                }
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        LOGGER.info("Class TileEntityHeatingMachine patched successfully!");
        return cw.toByteArray();
    }

    static {
        REPLACEMENTS.put("ic2/core/block/invslot/InvSlotProcessableGeneric", "(Lic2/core/block/TileEntityInventory;Ljava/lang/String;ILic2/api/recipe/IMachineRecipeManager;)V");
        REPLACEMENTS.put("ic2/core/block/invslot/InvSlotOutput", "(Lic2/core/block/TileEntityInventory;Ljava/lang/String;I)V");
        REPLACEMENTS.put("ic2/core/block/invslot/InvSlotUpgrade", "(Lic2/core/block/TileEntityInventory;Ljava/lang/String;I)V");
    }
}

