/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jaquadro.minecraft.chameleon.model.KeyedBlockState;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class CachedBuilderModel
implements IBakedModel {
    LoadingCache<KeyedBlockState, IBakedModel> modelCache;
    private IBlockState baseState;
    private ProxyBuilderModel model;

    public CachedBuilderModel(ProxyBuilderModel model) {
        this(model, null);
    }

    public CachedBuilderModel(final ProxyBuilderModel model, IBlockState baseState) {
        this.model = model;
        this.baseState = baseState;
        this.modelCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<KeyedBlockState, IBakedModel>(){

            public IBakedModel load(KeyedBlockState key) throws Exception {
                return model.buildModel(key.getState());
            }
        });
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.getModel(state).func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.getModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getModel().func_177556_c();
    }

    public boolean func_188618_c() {
        return this.getModel().func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getModel().func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.getModel().func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.getModel().func_188617_f();
    }

    private IBakedModel getModel() {
        return this.getModel(this.baseState);
    }

    private IBakedModel getModel(IBlockState state) {
        try {
            if (state == null) {
                return this.model;
            }
            return (IBakedModel)this.modelCache.get((Object)new KeyedBlockState(state, this.model.getKey(state)));
        }
        catch (Exception e) {
            return this.model;
        }
    }
}

