/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.definitions.IItems;
import appeng.api.definitions.ITileDefinition;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.core.sync.packets.PacketPartPlacement;
import appeng.facade.IFacadeItem;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PartPlacement {
    private static float eyeHeight = 0.0f;
    private final ThreadLocal<Object> placing = new ThreadLocal();
    private boolean wasCanceled = false;

    /*
     * Enabled aggressive block sorting
     */
    public static EnumActionResult place(ItemStack held, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand, World world, PlaceType pass, int depth) {
        DimensionalCoord dc;
        IFacadePart fp;
        if (depth > 3) {
            return EnumActionResult.FAIL;
        }
        if (!held.func_190926_b() && Platform.isWrench(player, held, pos) && player.func_70093_af()) {
            if (!Platform.hasPermissions(new DimensionalCoord(world, pos), player)) {
                return EnumActionResult.FAIL;
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            TileEntity tile = world.func_175625_s(pos);
            IPartHost host = null;
            if (tile instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null) return EnumActionResult.PASS;
            if (world.field_72995_K) {
                player.func_184609_a(hand);
                NetworkHandler.instance().sendToServer(new PacketPartPlacement(pos, side, PartPlacement.getEyeOffset(player), hand));
                return EnumActionResult.SUCCESS;
            }
            LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
            RayTraceResult mop = block.func_180636_a(world.func_180495_p(pos), world, pos, dir.getA(), dir.getB());
            if (mop == null) return EnumActionResult.SUCCESS;
            ArrayList<ItemStack> is = new ArrayList<ItemStack>();
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.field_72307_f.func_72441_c((double)(-mop.func_178782_a().func_177958_n()), (double)(-mop.func_178782_a().func_177956_o()), (double)(-mop.func_178782_a().func_177952_p())));
            if (sp.part != null) {
                is.add(sp.part.getItemStack(PartItemStack.WRENCH));
                sp.part.getDrops(is, true);
                host.removePart(sp.side, false);
            }
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                host.getFacadeContainer().removeFacade(host, sp.side);
                Platform.notifyBlocksOfNeighbors(world, pos);
            }
            if (host.isEmpty()) {
                host.cleanup();
            }
            if (is.isEmpty()) return EnumActionResult.SUCCESS;
            Platform.spawnDrops(world, pos, is);
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        IPartHost host = null;
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
        }
        if (!held.func_190926_b() && (fp = PartPlacement.isFacade(held, AEPartLocation.fromFacing(side))) != null) {
            if (host == null) return EnumActionResult.FAIL;
            if (world.field_72995_K) {
                player.func_184609_a(hand);
                NetworkHandler.instance().sendToServer(new PacketPartPlacement(pos, side, PartPlacement.getEyeOffset(player), hand));
                return EnumActionResult.SUCCESS;
            }
            if (host.getPart(AEPartLocation.INTERNAL) == null) {
                return EnumActionResult.FAIL;
            }
            if (!host.canAddPart(held, AEPartLocation.fromFacing(side))) return EnumActionResult.FAIL;
            if (!host.getFacadeContainer().addFacade(fp)) return EnumActionResult.FAIL;
            host.markForSave();
            host.markForUpdate();
            if (player.field_71075_bZ.field_75098_d) return EnumActionResult.SUCCESS;
            held.func_190917_f(-1);
            if (held.func_190916_E() != 0) return EnumActionResult.SUCCESS;
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
            return EnumActionResult.SUCCESS;
        }
        if (held.func_190926_b()) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (host != null && player.func_70093_af() && block != null) {
                LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
                RayTraceResult mop = block.func_180636_a(world.func_180495_p(pos), world, pos, dir.getA(), dir.getB());
                if (mop != null) {
                    mop.field_72307_f = mop.field_72307_f.func_72441_c((double)(-mop.func_178782_a().func_177958_n()), (double)(-mop.func_178782_a().func_177956_o()), (double)(-mop.func_178782_a().func_177952_p()));
                    SelectedPart sPart = PartPlacement.selectPart(player, host, mop.field_72307_f);
                    if (sPart != null && sPart.part != null && sPart.part.onShiftActivate(player, hand, mop.field_72307_f)) {
                        if (!world.field_72995_K) return EnumActionResult.SUCCESS;
                        NetworkHandler.instance().sendToServer(new PacketPartPlacement(pos, side, PartPlacement.getEyeOffset(player), hand));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        if (held.func_190926_b()) return EnumActionResult.PASS;
        if (!(held.func_77973_b() instanceof IPartItem)) {
            return EnumActionResult.PASS;
        }
        BlockPos te_pos = pos;
        ITileDefinition multiPart = AEApi.instance().definitions().blocks().multiPart();
        if (host == null && pass == PlaceType.PLACE_ITEM) {
            EnumFacing offset = null;
            Block blkID = world.func_180495_p(pos).func_177230_c();
            if (blkID != null && !blkID.func_176200_f((IBlockAccess)world, pos)) {
                offset = side;
                if (Platform.isServer()) {
                    side = side.func_176734_d();
                }
            }
            if ((tile = world.func_175625_s(te_pos = offset == null ? pos : pos.func_177972_a(offset))) instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            Optional<ItemStack> maybeMultiPartStack = multiPart.maybeStack(1);
            Optional<Block> maybeMultiPartBlock = multiPart.maybeBlock();
            Optional<ItemBlock> maybeMultiPartItemBlock = multiPart.maybeItemBlock();
            boolean hostIsNotPresent = host == null;
            boolean multiPartPresent = maybeMultiPartBlock.isPresent() && maybeMultiPartStack.isPresent() && maybeMultiPartItemBlock.isPresent();
            boolean canMultiPartBePlaced = maybeMultiPartBlock.get().func_176196_c(world, te_pos);
            if (hostIsNotPresent && multiPartPresent && canMultiPartBePlaced && maybeMultiPartItemBlock.get().placeBlockAt(maybeMultiPartStack.get(), player, world, te_pos, side, 0.5f, 0.5f, 0.5f, maybeMultiPartBlock.get().func_176223_P())) {
                if (world.field_72995_K) {
                    player.func_184609_a(hand);
                    NetworkHandler.instance().sendToServer(new PacketPartPlacement(pos, side, PartPlacement.getEyeOffset(player), hand));
                    return EnumActionResult.SUCCESS;
                }
                tile = world.func_175625_s(te_pos);
                if (tile instanceof IPartHost) {
                    host = (IPartHost)tile;
                }
                pass = PlaceType.INTERACT_SECOND_PASS;
            } else if (host != null && !host.canAddPart(held, AEPartLocation.fromFacing(side))) {
                return EnumActionResult.FAIL;
            }
        }
        if (host == null) {
            return EnumActionResult.PASS;
        }
        if (!host.canAddPart(held, AEPartLocation.fromFacing(side))) {
            PlaceType placeType;
            Block blkID;
            if (pass != PlaceType.INTERACT_FIRST_PASS) {
                if (pass != PlaceType.PLACE_ITEM) return EnumActionResult.PASS;
            }
            if ((blkID = world.func_180495_p(te_pos = pos.func_177972_a(side)).func_177230_c()) != null && !blkID.func_176200_f((IBlockAccess)world, te_pos)) {
                if (host == null) return EnumActionResult.PASS;
            }
            EnumFacing enumFacing = side.func_176734_d();
            if (pass == PlaceType.INTERACT_FIRST_PASS) {
                placeType = PlaceType.INTERACT_SECOND_PASS;
                return PartPlacement.place(held, te_pos, enumFacing, player, hand, world, placeType, depth + 1);
            }
            placeType = PlaceType.PLACE_ITEM;
            return PartPlacement.place(held, te_pos, enumFacing, player, hand, world, placeType, depth + 1);
        }
        if (world.field_72995_K) {
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
        RayTraceResult mop = state.func_177230_c().func_180636_a(state, world, pos, dir.getA(), dir.getB());
        if (mop != null) {
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.field_72307_f.func_72441_c((double)(-mop.func_178782_a().func_177958_n()), (double)(-mop.func_178782_a().func_177956_o()), (double)(-mop.func_178782_a().func_177952_p())));
            if (sp.part != null && !player.func_70093_af() && sp.part.onActivate(player, hand, mop.field_72307_f)) {
                return EnumActionResult.FAIL;
            }
        }
        if (!Platform.hasPermissions(dc = host.getLocation(), player)) {
            return EnumActionResult.FAIL;
        }
        AEPartLocation mySide = host.addPart(held, AEPartLocation.fromFacing(side), player, hand);
        if (mySide == null) return EnumActionResult.SUCCESS;
        multiPart.maybeBlock().ifPresent(multiPartBlock -> {
            SoundType ss = multiPartBlock.getSoundType(state, world, pos, (Entity)player);
            world.func_184133_a(null, pos, ss.func_185841_e(), SoundCategory.BLOCKS, (ss.func_185843_a() + 1.0f) / 2.0f, ss.func_185847_b() * 0.8f);
        });
        if (player.field_71075_bZ.field_75098_d) return EnumActionResult.SUCCESS;
        held.func_190917_f(-1);
        if (held.func_190916_E() != 0) return EnumActionResult.SUCCESS;
        player.func_184611_a(hand, ItemStack.field_190927_a);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
        return EnumActionResult.SUCCESS;
    }

    private static float getEyeOffset(EntityPlayer p) {
        if (p.field_70170_p.field_72995_K) {
            return Platform.getEyeOffset(p);
        }
        return PartPlacement.getEyeHeight();
    }

    private static SelectedPart selectPart(EntityPlayer player, IPartHost host, Vec3d pos) {
        AppEng.proxy.updateRenderMode(player);
        SelectedPart sp = host.selectPart(pos);
        AppEng.proxy.updateRenderMode(null);
        return sp;
    }

    public static IFacadePart isFacade(ItemStack held, AEPartLocation side) {
        if (held.func_77973_b() instanceof IFacadeItem) {
            return ((IFacadeItem)held.func_77973_b()).createPartFromItemStack(held, side);
        }
        return null;
    }

    @SubscribeEvent
    public void playerInteract(TickEvent.ClientTickEvent event) {
        this.wasCanceled = false;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        if (event instanceof PlayerInteractEvent.RightClickEmpty && event.getEntityPlayer().field_70170_p.field_72995_K) {
            RayTraceResult mop = Platform.rayTrace(event.getEntityPlayer(), true, false);
            Minecraft mc = Minecraft.func_71410_x();
            float f = 1.0f;
            double d0 = mc.field_71442_b.func_78757_d();
            Vec3d vec3 = mc.func_175606_aa().func_174824_e(1.0f);
            if (mop != null && mop.field_72307_f.func_72438_d(vec3) < d0) {
                World w = event.getEntity().field_70170_p;
                TileEntity te = w.func_175625_s(mop.func_178782_a());
                if (te instanceof IPartHost && this.wasCanceled) {
                    event.setCanceled(true);
                }
            } else {
                ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
                IItems items = AEApi.instance().definitions().items();
                boolean supportedItem = items.memoryCard().isSameAs(held);
                if (event.getEntityPlayer().func_70093_af() && !held.func_190926_b() && (supportedItem |= items.colorApplicator().isSameAs(held))) {
                    NetworkHandler.instance().sendToServer(new PacketClick(event.getPos(), event.getFace(), 0.0f, 0.0f, 0.0f, event.getHand()));
                }
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && !event.getEntityPlayer().field_70170_p.field_72995_K) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
            if (PartPlacement.place(held, event.getPos(), event.getFace(), event.getEntityPlayer(), event.getHand(), event.getEntityPlayer().field_70170_p, PlaceType.INTERACT_FIRST_PASS, 0) == EnumActionResult.SUCCESS) {
                event.setCanceled(true);
                this.wasCanceled = true;
            }
            this.placing.set(null);
        }
    }

    private static float getEyeHeight() {
        return eyeHeight;
    }

    public static void setEyeHeight(float eyeHeight) {
        PartPlacement.eyeHeight = eyeHeight;
    }

    public static enum PlaceType {
        PLACE_ITEM,
        INTERACT_FIRST_PASS,
        INTERACT_SECOND_PASS;

    }
}

